/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingPolicyMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingPolicyMetric> {
    private static final SdkField<Integer> INVOCATIONS_PER_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InvocationsPerInstance").getter(ScalingPolicyMetric.getter(ScalingPolicyMetric::invocationsPerInstance)).setter(ScalingPolicyMetric.setter(Builder::invocationsPerInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationsPerInstance").build()}).build();
    private static final SdkField<Integer> MODEL_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ModelLatency").getter(ScalingPolicyMetric.getter(ScalingPolicyMetric::modelLatency)).setter(ScalingPolicyMetric.setter(Builder::modelLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelLatency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATIONS_PER_INSTANCE_FIELD, MODEL_LATENCY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InvocationsPerInstance", INVOCATIONS_PER_INSTANCE_FIELD);
            this.put("ModelLatency", MODEL_LATENCY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer invocationsPerInstance;
    private final Integer modelLatency;

    private ScalingPolicyMetric(BuilderImpl builder) {
        this.invocationsPerInstance = builder.invocationsPerInstance;
        this.modelLatency = builder.modelLatency;
    }

    public final Integer invocationsPerInstance() {
        return this.invocationsPerInstance;
    }

    public final Integer modelLatency() {
        return this.modelLatency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationsPerInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelLatency());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicyMetric)) {
            return false;
        }
        ScalingPolicyMetric other = (ScalingPolicyMetric)obj;
        return Objects.equals(this.invocationsPerInstance(), other.invocationsPerInstance()) && Objects.equals(this.modelLatency(), other.modelLatency());
    }

    public final String toString() {
        return ToString.builder((String)"ScalingPolicyMetric").add("InvocationsPerInstance", (Object)this.invocationsPerInstance()).add("ModelLatency", (Object)this.modelLatency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvocationsPerInstance": {
                return Optional.ofNullable(clazz.cast(this.invocationsPerInstance()));
            }
            case "ModelLatency": {
                return Optional.ofNullable(clazz.cast(this.modelLatency()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ScalingPolicyMetric, T> g) {
        return obj -> g.apply((ScalingPolicyMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer invocationsPerInstance;
        private Integer modelLatency;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicyMetric model) {
            this.invocationsPerInstance(model.invocationsPerInstance);
            this.modelLatency(model.modelLatency);
        }

        public final Integer getInvocationsPerInstance() {
            return this.invocationsPerInstance;
        }

        public final void setInvocationsPerInstance(Integer invocationsPerInstance) {
            this.invocationsPerInstance = invocationsPerInstance;
        }

        @Override
        public final Builder invocationsPerInstance(Integer invocationsPerInstance) {
            this.invocationsPerInstance = invocationsPerInstance;
            return this;
        }

        public final Integer getModelLatency() {
            return this.modelLatency;
        }

        public final void setModelLatency(Integer modelLatency) {
            this.modelLatency = modelLatency;
        }

        @Override
        public final Builder modelLatency(Integer modelLatency) {
            this.modelLatency = modelLatency;
            return this;
        }

        public ScalingPolicyMetric build() {
            return new ScalingPolicyMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingPolicyMetric> {
        public Builder invocationsPerInstance(Integer var1);

        public Builder modelLatency(Integer var1);
    }
}

