/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringNetworkConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringNetworkConfig> {
    private static final SdkField<Boolean> ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableInterContainerTrafficEncryption").getter(MonitoringNetworkConfig.getter(MonitoringNetworkConfig::enableInterContainerTrafficEncryption)).setter(MonitoringNetworkConfig.setter(Builder::enableInterContainerTrafficEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableInterContainerTrafficEncryption").build()}).build();
    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableNetworkIsolation").getter(MonitoringNetworkConfig.getter(MonitoringNetworkConfig::enableNetworkIsolation)).setter(MonitoringNetworkConfig.setter(Builder::enableNetworkIsolation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(MonitoringNetworkConfig.getter(MonitoringNetworkConfig::vpcConfig)).setter(MonitoringNetworkConfig.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD, ENABLE_NETWORK_ISOLATION_FIELD, VPC_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EnableInterContainerTrafficEncryption", ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD);
            this.put("EnableNetworkIsolation", ENABLE_NETWORK_ISOLATION_FIELD);
            this.put("VpcConfig", VPC_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean enableInterContainerTrafficEncryption;
    private final Boolean enableNetworkIsolation;
    private final VpcConfig vpcConfig;

    private MonitoringNetworkConfig(BuilderImpl builder) {
        this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
        this.vpcConfig = builder.vpcConfig;
    }

    public final Boolean enableInterContainerTrafficEncryption() {
        return this.enableInterContainerTrafficEncryption;
    }

    public final Boolean enableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableInterContainerTrafficEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableNetworkIsolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringNetworkConfig)) {
            return false;
        }
        MonitoringNetworkConfig other = (MonitoringNetworkConfig)obj;
        return Objects.equals(this.enableInterContainerTrafficEncryption(), other.enableInterContainerTrafficEncryption()) && Objects.equals(this.enableNetworkIsolation(), other.enableNetworkIsolation()) && Objects.equals(this.vpcConfig(), other.vpcConfig());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoringNetworkConfig").add("EnableInterContainerTrafficEncryption", (Object)this.enableInterContainerTrafficEncryption()).add("EnableNetworkIsolation", (Object)this.enableNetworkIsolation()).add("VpcConfig", (Object)this.vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableInterContainerTrafficEncryption": {
                return Optional.ofNullable(clazz.cast(this.enableInterContainerTrafficEncryption()));
            }
            case "EnableNetworkIsolation": {
                return Optional.ofNullable(clazz.cast(this.enableNetworkIsolation()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringNetworkConfig, T> g) {
        return obj -> g.apply((MonitoringNetworkConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enableInterContainerTrafficEncryption;
        private Boolean enableNetworkIsolation;
        private VpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringNetworkConfig model) {
            this.enableInterContainerTrafficEncryption(model.enableInterContainerTrafficEncryption);
            this.enableNetworkIsolation(model.enableNetworkIsolation);
            this.vpcConfig(model.vpcConfig);
        }

        public final Boolean getEnableInterContainerTrafficEncryption() {
            return this.enableInterContainerTrafficEncryption;
        }

        public final void setEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
        }

        @Override
        public final Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
            return this;
        }

        public final Boolean getEnableNetworkIsolation() {
            return this.enableNetworkIsolation;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public MonitoringNetworkConfig build() {
            return new MonitoringNetworkConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringNetworkConfig> {
        public Builder enableInterContainerTrafficEncryption(Boolean var1);

        public Builder enableNetworkIsolation(Boolean var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }
    }
}

