/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.DeviceSelectionConfig;
import software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentConfig;
import software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentStageStatusSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentStageStatusSummary> {
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StageName").getter(DeploymentStageStatusSummary.getter(DeploymentStageStatusSummary::stageName)).setter(DeploymentStageStatusSummary.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageName").build()}).build();
    private static final SdkField<DeviceSelectionConfig> DEVICE_SELECTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceSelectionConfig").getter(DeploymentStageStatusSummary.getter(DeploymentStageStatusSummary::deviceSelectionConfig)).setter(DeploymentStageStatusSummary.setter(Builder::deviceSelectionConfig)).constructor(DeviceSelectionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceSelectionConfig").build()}).build();
    private static final SdkField<EdgeDeploymentConfig> DEPLOYMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeploymentConfig").getter(DeploymentStageStatusSummary.getter(DeploymentStageStatusSummary::deploymentConfig)).setter(DeploymentStageStatusSummary.setter(Builder::deploymentConfig)).constructor(EdgeDeploymentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfig").build()}).build();
    private static final SdkField<EdgeDeploymentStatus> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeploymentStatus").getter(DeploymentStageStatusSummary.getter(DeploymentStageStatusSummary::deploymentStatus)).setter(DeploymentStageStatusSummary.setter(Builder::deploymentStatus)).constructor(EdgeDeploymentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_NAME_FIELD, DEVICE_SELECTION_CONFIG_FIELD, DEPLOYMENT_CONFIG_FIELD, DEPLOYMENT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StageName", STAGE_NAME_FIELD);
            this.put("DeviceSelectionConfig", DEVICE_SELECTION_CONFIG_FIELD);
            this.put("DeploymentConfig", DEPLOYMENT_CONFIG_FIELD);
            this.put("DeploymentStatus", DEPLOYMENT_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String stageName;
    private final DeviceSelectionConfig deviceSelectionConfig;
    private final EdgeDeploymentConfig deploymentConfig;
    private final EdgeDeploymentStatus deploymentStatus;

    private DeploymentStageStatusSummary(BuilderImpl builder) {
        this.stageName = builder.stageName;
        this.deviceSelectionConfig = builder.deviceSelectionConfig;
        this.deploymentConfig = builder.deploymentConfig;
        this.deploymentStatus = builder.deploymentStatus;
    }

    public final String stageName() {
        return this.stageName;
    }

    public final DeviceSelectionConfig deviceSelectionConfig() {
        return this.deviceSelectionConfig;
    }

    public final EdgeDeploymentConfig deploymentConfig() {
        return this.deploymentConfig;
    }

    public final EdgeDeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceSelectionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentStageStatusSummary)) {
            return false;
        }
        DeploymentStageStatusSummary other = (DeploymentStageStatusSummary)obj;
        return Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.deviceSelectionConfig(), other.deviceSelectionConfig()) && Objects.equals(this.deploymentConfig(), other.deploymentConfig()) && Objects.equals(this.deploymentStatus(), other.deploymentStatus());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentStageStatusSummary").add("StageName", (Object)this.stageName()).add("DeviceSelectionConfig", (Object)this.deviceSelectionConfig()).add("DeploymentConfig", (Object)this.deploymentConfig()).add("DeploymentStatus", (Object)this.deploymentStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "DeviceSelectionConfig": {
                return Optional.ofNullable(clazz.cast(this.deviceSelectionConfig()));
            }
            case "DeploymentConfig": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfig()));
            }
            case "DeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentStageStatusSummary, T> g) {
        return obj -> g.apply((DeploymentStageStatusSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stageName;
        private DeviceSelectionConfig deviceSelectionConfig;
        private EdgeDeploymentConfig deploymentConfig;
        private EdgeDeploymentStatus deploymentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentStageStatusSummary model) {
            this.stageName(model.stageName);
            this.deviceSelectionConfig(model.deviceSelectionConfig);
            this.deploymentConfig(model.deploymentConfig);
            this.deploymentStatus(model.deploymentStatus);
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final DeviceSelectionConfig.Builder getDeviceSelectionConfig() {
            return this.deviceSelectionConfig != null ? this.deviceSelectionConfig.toBuilder() : null;
        }

        public final void setDeviceSelectionConfig(DeviceSelectionConfig.BuilderImpl deviceSelectionConfig) {
            this.deviceSelectionConfig = deviceSelectionConfig != null ? deviceSelectionConfig.build() : null;
        }

        @Override
        public final Builder deviceSelectionConfig(DeviceSelectionConfig deviceSelectionConfig) {
            this.deviceSelectionConfig = deviceSelectionConfig;
            return this;
        }

        public final EdgeDeploymentConfig.Builder getDeploymentConfig() {
            return this.deploymentConfig != null ? this.deploymentConfig.toBuilder() : null;
        }

        public final void setDeploymentConfig(EdgeDeploymentConfig.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        @Override
        public final Builder deploymentConfig(EdgeDeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        public final EdgeDeploymentStatus.Builder getDeploymentStatus() {
            return this.deploymentStatus != null ? this.deploymentStatus.toBuilder() : null;
        }

        public final void setDeploymentStatus(EdgeDeploymentStatus.BuilderImpl deploymentStatus) {
            this.deploymentStatus = deploymentStatus != null ? deploymentStatus.build() : null;
        }

        @Override
        public final Builder deploymentStatus(EdgeDeploymentStatus deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        public DeploymentStageStatusSummary build() {
            return new DeploymentStageStatusSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentStageStatusSummary> {
        public Builder stageName(String var1);

        public Builder deviceSelectionConfig(DeviceSelectionConfig var1);

        default public Builder deviceSelectionConfig(Consumer<DeviceSelectionConfig.Builder> deviceSelectionConfig) {
            return this.deviceSelectionConfig((DeviceSelectionConfig)((DeviceSelectionConfig.Builder)DeviceSelectionConfig.builder().applyMutation(deviceSelectionConfig)).build());
        }

        public Builder deploymentConfig(EdgeDeploymentConfig var1);

        default public Builder deploymentConfig(Consumer<EdgeDeploymentConfig.Builder> deploymentConfig) {
            return this.deploymentConfig((EdgeDeploymentConfig)((EdgeDeploymentConfig.Builder)EdgeDeploymentConfig.builder().applyMutation(deploymentConfig)).build());
        }

        public Builder deploymentStatus(EdgeDeploymentStatus var1);

        default public Builder deploymentStatus(Consumer<EdgeDeploymentStatus.Builder> deploymentStatus) {
            return this.deploymentStatus((EdgeDeploymentStatus)((EdgeDeploymentStatus.Builder)EdgeDeploymentStatus.builder().applyMutation(deploymentStatus)).build());
        }
    }
}

