/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AutoParameter;
import software.amazon.awssdk.services.sagemaker.model.AutoParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.CategoricalParameterRange;
import software.amazon.awssdk.services.sagemaker.model.CategoricalParameterRangesCopier;
import software.amazon.awssdk.services.sagemaker.model.ContinuousParameterRange;
import software.amazon.awssdk.services.sagemaker.model.ContinuousParameterRangesCopier;
import software.amazon.awssdk.services.sagemaker.model.IntegerParameterRange;
import software.amazon.awssdk.services.sagemaker.model.IntegerParameterRangesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParameterRanges
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParameterRanges> {
    private static final SdkField<List<IntegerParameterRange>> INTEGER_PARAMETER_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IntegerParameterRanges").getter(ParameterRanges.getter(ParameterRanges::integerParameterRanges)).setter(ParameterRanges.setter(Builder::integerParameterRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerParameterRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IntegerParameterRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ContinuousParameterRange>> CONTINUOUS_PARAMETER_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContinuousParameterRanges").getter(ParameterRanges.getter(ParameterRanges::continuousParameterRanges)).setter(ParameterRanges.setter(Builder::continuousParameterRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuousParameterRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContinuousParameterRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CategoricalParameterRange>> CATEGORICAL_PARAMETER_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CategoricalParameterRanges").getter(ParameterRanges.getter(ParameterRanges::categoricalParameterRanges)).setter(ParameterRanges.setter(Builder::categoricalParameterRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoricalParameterRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CategoricalParameterRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AutoParameter>> AUTO_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutoParameters").getter(ParameterRanges.getter(ParameterRanges::autoParameters)).setter(ParameterRanges.setter(Builder::autoParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGER_PARAMETER_RANGES_FIELD, CONTINUOUS_PARAMETER_RANGES_FIELD, CATEGORICAL_PARAMETER_RANGES_FIELD, AUTO_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IntegerParameterRanges", INTEGER_PARAMETER_RANGES_FIELD);
            this.put("ContinuousParameterRanges", CONTINUOUS_PARAMETER_RANGES_FIELD);
            this.put("CategoricalParameterRanges", CATEGORICAL_PARAMETER_RANGES_FIELD);
            this.put("AutoParameters", AUTO_PARAMETERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<IntegerParameterRange> integerParameterRanges;
    private final List<ContinuousParameterRange> continuousParameterRanges;
    private final List<CategoricalParameterRange> categoricalParameterRanges;
    private final List<AutoParameter> autoParameters;

    private ParameterRanges(BuilderImpl builder) {
        this.integerParameterRanges = builder.integerParameterRanges;
        this.continuousParameterRanges = builder.continuousParameterRanges;
        this.categoricalParameterRanges = builder.categoricalParameterRanges;
        this.autoParameters = builder.autoParameters;
    }

    public final boolean hasIntegerParameterRanges() {
        return this.integerParameterRanges != null && !(this.integerParameterRanges instanceof SdkAutoConstructList);
    }

    public final List<IntegerParameterRange> integerParameterRanges() {
        return this.integerParameterRanges;
    }

    public final boolean hasContinuousParameterRanges() {
        return this.continuousParameterRanges != null && !(this.continuousParameterRanges instanceof SdkAutoConstructList);
    }

    public final List<ContinuousParameterRange> continuousParameterRanges() {
        return this.continuousParameterRanges;
    }

    public final boolean hasCategoricalParameterRanges() {
        return this.categoricalParameterRanges != null && !(this.categoricalParameterRanges instanceof SdkAutoConstructList);
    }

    public final List<CategoricalParameterRange> categoricalParameterRanges() {
        return this.categoricalParameterRanges;
    }

    public final boolean hasAutoParameters() {
        return this.autoParameters != null && !(this.autoParameters instanceof SdkAutoConstructList);
    }

    public final List<AutoParameter> autoParameters() {
        return this.autoParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegerParameterRanges() ? this.integerParameterRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContinuousParameterRanges() ? this.continuousParameterRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategoricalParameterRanges() ? this.categoricalParameterRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoParameters() ? this.autoParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterRanges)) {
            return false;
        }
        ParameterRanges other = (ParameterRanges)obj;
        return this.hasIntegerParameterRanges() == other.hasIntegerParameterRanges() && Objects.equals(this.integerParameterRanges(), other.integerParameterRanges()) && this.hasContinuousParameterRanges() == other.hasContinuousParameterRanges() && Objects.equals(this.continuousParameterRanges(), other.continuousParameterRanges()) && this.hasCategoricalParameterRanges() == other.hasCategoricalParameterRanges() && Objects.equals(this.categoricalParameterRanges(), other.categoricalParameterRanges()) && this.hasAutoParameters() == other.hasAutoParameters() && Objects.equals(this.autoParameters(), other.autoParameters());
    }

    public final String toString() {
        return ToString.builder((String)"ParameterRanges").add("IntegerParameterRanges", this.hasIntegerParameterRanges() ? this.integerParameterRanges() : null).add("ContinuousParameterRanges", this.hasContinuousParameterRanges() ? this.continuousParameterRanges() : null).add("CategoricalParameterRanges", this.hasCategoricalParameterRanges() ? this.categoricalParameterRanges() : null).add("AutoParameters", this.hasAutoParameters() ? this.autoParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IntegerParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.integerParameterRanges()));
            }
            case "ContinuousParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.continuousParameterRanges()));
            }
            case "CategoricalParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.categoricalParameterRanges()));
            }
            case "AutoParameters": {
                return Optional.ofNullable(clazz.cast(this.autoParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ParameterRanges, T> g) {
        return obj -> g.apply((ParameterRanges)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<IntegerParameterRange> integerParameterRanges = DefaultSdkAutoConstructList.getInstance();
        private List<ContinuousParameterRange> continuousParameterRanges = DefaultSdkAutoConstructList.getInstance();
        private List<CategoricalParameterRange> categoricalParameterRanges = DefaultSdkAutoConstructList.getInstance();
        private List<AutoParameter> autoParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterRanges model) {
            this.integerParameterRanges(model.integerParameterRanges);
            this.continuousParameterRanges(model.continuousParameterRanges);
            this.categoricalParameterRanges(model.categoricalParameterRanges);
            this.autoParameters(model.autoParameters);
        }

        public final List<IntegerParameterRange.Builder> getIntegerParameterRanges() {
            List<IntegerParameterRange.Builder> result = IntegerParameterRangesCopier.copyToBuilder(this.integerParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegerParameterRanges(Collection<IntegerParameterRange.BuilderImpl> integerParameterRanges) {
            this.integerParameterRanges = IntegerParameterRangesCopier.copyFromBuilder(integerParameterRanges);
        }

        @Override
        public final Builder integerParameterRanges(Collection<IntegerParameterRange> integerParameterRanges) {
            this.integerParameterRanges = IntegerParameterRangesCopier.copy(integerParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerParameterRanges(IntegerParameterRange ... integerParameterRanges) {
            this.integerParameterRanges(Arrays.asList(integerParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integerParameterRanges(Consumer<IntegerParameterRange.Builder> ... integerParameterRanges) {
            this.integerParameterRanges(Stream.of(integerParameterRanges).map(c -> (IntegerParameterRange)((IntegerParameterRange.Builder)IntegerParameterRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContinuousParameterRange.Builder> getContinuousParameterRanges() {
            List<ContinuousParameterRange.Builder> result = ContinuousParameterRangesCopier.copyToBuilder(this.continuousParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContinuousParameterRanges(Collection<ContinuousParameterRange.BuilderImpl> continuousParameterRanges) {
            this.continuousParameterRanges = ContinuousParameterRangesCopier.copyFromBuilder(continuousParameterRanges);
        }

        @Override
        public final Builder continuousParameterRanges(Collection<ContinuousParameterRange> continuousParameterRanges) {
            this.continuousParameterRanges = ContinuousParameterRangesCopier.copy(continuousParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousParameterRanges(ContinuousParameterRange ... continuousParameterRanges) {
            this.continuousParameterRanges(Arrays.asList(continuousParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder continuousParameterRanges(Consumer<ContinuousParameterRange.Builder> ... continuousParameterRanges) {
            this.continuousParameterRanges(Stream.of(continuousParameterRanges).map(c -> (ContinuousParameterRange)((ContinuousParameterRange.Builder)ContinuousParameterRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CategoricalParameterRange.Builder> getCategoricalParameterRanges() {
            List<CategoricalParameterRange.Builder> result = CategoricalParameterRangesCopier.copyToBuilder(this.categoricalParameterRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategoricalParameterRanges(Collection<CategoricalParameterRange.BuilderImpl> categoricalParameterRanges) {
            this.categoricalParameterRanges = CategoricalParameterRangesCopier.copyFromBuilder(categoricalParameterRanges);
        }

        @Override
        public final Builder categoricalParameterRanges(Collection<CategoricalParameterRange> categoricalParameterRanges) {
            this.categoricalParameterRanges = CategoricalParameterRangesCopier.copy(categoricalParameterRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalParameterRanges(CategoricalParameterRange ... categoricalParameterRanges) {
            this.categoricalParameterRanges(Arrays.asList(categoricalParameterRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoricalParameterRanges(Consumer<CategoricalParameterRange.Builder> ... categoricalParameterRanges) {
            this.categoricalParameterRanges(Stream.of(categoricalParameterRanges).map(c -> (CategoricalParameterRange)((CategoricalParameterRange.Builder)CategoricalParameterRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AutoParameter.Builder> getAutoParameters() {
            List<AutoParameter.Builder> result = AutoParametersCopier.copyToBuilder(this.autoParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoParameters(Collection<AutoParameter.BuilderImpl> autoParameters) {
            this.autoParameters = AutoParametersCopier.copyFromBuilder(autoParameters);
        }

        @Override
        public final Builder autoParameters(Collection<AutoParameter> autoParameters) {
            this.autoParameters = AutoParametersCopier.copy(autoParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoParameters(AutoParameter ... autoParameters) {
            this.autoParameters(Arrays.asList(autoParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoParameters(Consumer<AutoParameter.Builder> ... autoParameters) {
            this.autoParameters(Stream.of(autoParameters).map(c -> (AutoParameter)((AutoParameter.Builder)AutoParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ParameterRanges build() {
            return new ParameterRanges(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParameterRanges> {
        public Builder integerParameterRanges(Collection<IntegerParameterRange> var1);

        public Builder integerParameterRanges(IntegerParameterRange ... var1);

        public Builder integerParameterRanges(Consumer<IntegerParameterRange.Builder> ... var1);

        public Builder continuousParameterRanges(Collection<ContinuousParameterRange> var1);

        public Builder continuousParameterRanges(ContinuousParameterRange ... var1);

        public Builder continuousParameterRanges(Consumer<ContinuousParameterRange.Builder> ... var1);

        public Builder categoricalParameterRanges(Collection<CategoricalParameterRange> var1);

        public Builder categoricalParameterRanges(CategoricalParameterRange ... var1);

        public Builder categoricalParameterRanges(Consumer<CategoricalParameterRange.Builder> ... var1);

        public Builder autoParameters(Collection<AutoParameter> var1);

        public Builder autoParameters(AutoParameter ... var1);

        public Builder autoParameters(Consumer<AutoParameter.Builder> ... var1);
    }
}

