/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupSpecification;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupSpecificationsCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterNodeRecovery;
import software.amazon.awssdk.services.sagemaker.model.ClusterOrchestrator;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClusterRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(CreateClusterRequest.getter(CreateClusterRequest::clusterName)).setter(CreateClusterRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<List<ClusterInstanceGroupSpecification>> INSTANCE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceGroups").getter(CreateClusterRequest.getter(CreateClusterRequest::instanceGroups)).setter(CreateClusterRequest.setter(Builder::instanceGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterInstanceGroupSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(CreateClusterRequest.getter(CreateClusterRequest::vpcConfig)).setter(CreateClusterRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateClusterRequest.getter(CreateClusterRequest::tags)).setter(CreateClusterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ClusterOrchestrator> ORCHESTRATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Orchestrator").getter(CreateClusterRequest.getter(CreateClusterRequest::orchestrator)).setter(CreateClusterRequest.setter(Builder::orchestrator)).constructor(ClusterOrchestrator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Orchestrator").build()}).build();
    private static final SdkField<String> NODE_RECOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeRecovery").getter(CreateClusterRequest.getter(CreateClusterRequest::nodeRecoveryAsString)).setter(CreateClusterRequest.setter(Builder::nodeRecovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeRecovery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, INSTANCE_GROUPS_FIELD, VPC_CONFIG_FIELD, TAGS_FIELD, ORCHESTRATOR_FIELD, NODE_RECOVERY_FIELD));
    private final String clusterName;
    private final List<ClusterInstanceGroupSpecification> instanceGroups;
    private final VpcConfig vpcConfig;
    private final List<Tag> tags;
    private final ClusterOrchestrator orchestrator;
    private final String nodeRecovery;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.instanceGroups = builder.instanceGroups;
        this.vpcConfig = builder.vpcConfig;
        this.tags = builder.tags;
        this.orchestrator = builder.orchestrator;
        this.nodeRecovery = builder.nodeRecovery;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final boolean hasInstanceGroups() {
        return this.instanceGroups != null && !(this.instanceGroups instanceof SdkAutoConstructList);
    }

    public final List<ClusterInstanceGroupSpecification> instanceGroups() {
        return this.instanceGroups;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ClusterOrchestrator orchestrator() {
        return this.orchestrator;
    }

    public final ClusterNodeRecovery nodeRecovery() {
        return ClusterNodeRecovery.fromValue(this.nodeRecovery);
    }

    public final String nodeRecoveryAsString() {
        return this.nodeRecovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceGroups() ? this.instanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.orchestrator());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeRecoveryAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && this.hasInstanceGroups() == other.hasInstanceGroups() && Objects.equals(this.instanceGroups(), other.instanceGroups()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.orchestrator(), other.orchestrator()) && Objects.equals(this.nodeRecoveryAsString(), other.nodeRecoveryAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateClusterRequest").add("ClusterName", (Object)this.clusterName()).add("InstanceGroups", this.hasInstanceGroups() ? this.instanceGroups() : null).add("VpcConfig", (Object)this.vpcConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("Orchestrator", (Object)this.orchestrator()).add("NodeRecovery", (Object)this.nodeRecoveryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "InstanceGroups": {
                return Optional.ofNullable(clazz.cast(this.instanceGroups()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Orchestrator": {
                return Optional.ofNullable(clazz.cast(this.orchestrator()));
            }
            case "NodeRecovery": {
                return Optional.ofNullable(clazz.cast(this.nodeRecoveryAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private List<ClusterInstanceGroupSpecification> instanceGroups = DefaultSdkAutoConstructList.getInstance();
        private VpcConfig vpcConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private ClusterOrchestrator orchestrator;
        private String nodeRecovery;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.instanceGroups(model.instanceGroups);
            this.vpcConfig(model.vpcConfig);
            this.tags(model.tags);
            this.orchestrator(model.orchestrator);
            this.nodeRecovery(model.nodeRecovery);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final List<ClusterInstanceGroupSpecification.Builder> getInstanceGroups() {
            List<ClusterInstanceGroupSpecification.Builder> result = ClusterInstanceGroupSpecificationsCopier.copyToBuilder(this.instanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceGroups(Collection<ClusterInstanceGroupSpecification.BuilderImpl> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupSpecificationsCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        public final Builder instanceGroups(Collection<ClusterInstanceGroupSpecification> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupSpecificationsCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(ClusterInstanceGroupSpecification ... instanceGroups) {
            this.instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<ClusterInstanceGroupSpecification.Builder> ... instanceGroups) {
            this.instanceGroups(Stream.of(instanceGroups).map(c -> (ClusterInstanceGroupSpecification)((ClusterInstanceGroupSpecification.Builder)ClusterInstanceGroupSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ClusterOrchestrator.Builder getOrchestrator() {
            return this.orchestrator != null ? this.orchestrator.toBuilder() : null;
        }

        public final void setOrchestrator(ClusterOrchestrator.BuilderImpl orchestrator) {
            this.orchestrator = orchestrator != null ? orchestrator.build() : null;
        }

        @Override
        public final Builder orchestrator(ClusterOrchestrator orchestrator) {
            this.orchestrator = orchestrator;
            return this;
        }

        public final String getNodeRecovery() {
            return this.nodeRecovery;
        }

        public final void setNodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
        }

        @Override
        public final Builder nodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
            return this;
        }

        @Override
        public final Builder nodeRecovery(ClusterNodeRecovery nodeRecovery) {
            this.nodeRecovery(nodeRecovery == null ? null : nodeRecovery.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClusterRequest> {
        public Builder clusterName(String var1);

        public Builder instanceGroups(Collection<ClusterInstanceGroupSpecification> var1);

        public Builder instanceGroups(ClusterInstanceGroupSpecification ... var1);

        public Builder instanceGroups(Consumer<ClusterInstanceGroupSpecification.Builder> ... var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder orchestrator(ClusterOrchestrator var1);

        default public Builder orchestrator(Consumer<ClusterOrchestrator.Builder> orchestrator) {
            return this.orchestrator((ClusterOrchestrator)((ClusterOrchestrator.Builder)ClusterOrchestrator.builder().applyMutation(orchestrator)).build());
        }

        public Builder nodeRecovery(String var1);

        public Builder nodeRecovery(ClusterNodeRecovery var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

