/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListMlflowTrackingServersRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMlflowTrackingServersResponse;
import software.amazon.awssdk.services.sagemaker.model.TrackingServerSummary;

public class ListMlflowTrackingServersIterable
implements SdkIterable<ListMlflowTrackingServersResponse> {
    private final SageMakerClient client;
    private final ListMlflowTrackingServersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMlflowTrackingServersIterable(SageMakerClient client, ListMlflowTrackingServersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMlflowTrackingServersResponseFetcher();
    }

    public Iterator<ListMlflowTrackingServersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrackingServerSummary> trackingServerSummaries() {
        Function<ListMlflowTrackingServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.trackingServerSummaries() != null) {
                return response.trackingServerSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMlflowTrackingServersResponseFetcher
    implements SyncPageFetcher<ListMlflowTrackingServersResponse> {
        private ListMlflowTrackingServersResponseFetcher() {
        }

        public boolean hasNextPage(ListMlflowTrackingServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMlflowTrackingServersResponse nextPage(ListMlflowTrackingServersResponse previousPage) {
            if (previousPage == null) {
                return ListMlflowTrackingServersIterable.this.client.listMlflowTrackingServers(ListMlflowTrackingServersIterable.this.firstRequest);
            }
            return ListMlflowTrackingServersIterable.this.client.listMlflowTrackingServers((ListMlflowTrackingServersRequest)((Object)ListMlflowTrackingServersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

