/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHubContentReferenceRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateHubContentReferenceRequest> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubName").getter(CreateHubContentReferenceRequest.getter(CreateHubContentReferenceRequest::hubName)).setter(CreateHubContentReferenceRequest.setter(Builder::hubName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()}).build();
    private static final SdkField<String> SAGE_MAKER_PUBLIC_HUB_CONTENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SageMakerPublicHubContentArn").getter(CreateHubContentReferenceRequest.getter(CreateHubContentReferenceRequest::sageMakerPublicHubContentArn)).setter(CreateHubContentReferenceRequest.setter(Builder::sageMakerPublicHubContentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerPublicHubContentArn").build()}).build();
    private static final SdkField<String> HUB_CONTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubContentName").getter(CreateHubContentReferenceRequest.getter(CreateHubContentReferenceRequest::hubContentName)).setter(CreateHubContentReferenceRequest.setter(Builder::hubContentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentName").build()}).build();
    private static final SdkField<String> MIN_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinVersion").getter(CreateHubContentReferenceRequest.getter(CreateHubContentReferenceRequest::minVersion)).setter(CreateHubContentReferenceRequest.setter(Builder::minVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinVersion").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateHubContentReferenceRequest.getter(CreateHubContentReferenceRequest::tags)).setter(CreateHubContentReferenceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD, SAGE_MAKER_PUBLIC_HUB_CONTENT_ARN_FIELD, HUB_CONTENT_NAME_FIELD, MIN_VERSION_FIELD, TAGS_FIELD));
    private final String hubName;
    private final String sageMakerPublicHubContentArn;
    private final String hubContentName;
    private final String minVersion;
    private final List<Tag> tags;

    private CreateHubContentReferenceRequest(BuilderImpl builder) {
        super(builder);
        this.hubName = builder.hubName;
        this.sageMakerPublicHubContentArn = builder.sageMakerPublicHubContentArn;
        this.hubContentName = builder.hubContentName;
        this.minVersion = builder.minVersion;
        this.tags = builder.tags;
    }

    public final String hubName() {
        return this.hubName;
    }

    public final String sageMakerPublicHubContentArn() {
        return this.sageMakerPublicHubContentArn;
    }

    public final String hubContentName() {
        return this.hubContentName;
    }

    public final String minVersion() {
        return this.minVersion;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hubName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerPublicHubContentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubContentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.minVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHubContentReferenceRequest)) {
            return false;
        }
        CreateHubContentReferenceRequest other = (CreateHubContentReferenceRequest)((Object)obj);
        return Objects.equals(this.hubName(), other.hubName()) && Objects.equals(this.sageMakerPublicHubContentArn(), other.sageMakerPublicHubContentArn()) && Objects.equals(this.hubContentName(), other.hubContentName()) && Objects.equals(this.minVersion(), other.minVersion()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateHubContentReferenceRequest").add("HubName", (Object)this.hubName()).add("SageMakerPublicHubContentArn", (Object)this.sageMakerPublicHubContentArn()).add("HubContentName", (Object)this.hubContentName()).add("MinVersion", (Object)this.minVersion()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubName": {
                return Optional.ofNullable(clazz.cast(this.hubName()));
            }
            case "SageMakerPublicHubContentArn": {
                return Optional.ofNullable(clazz.cast(this.sageMakerPublicHubContentArn()));
            }
            case "HubContentName": {
                return Optional.ofNullable(clazz.cast(this.hubContentName()));
            }
            case "MinVersion": {
                return Optional.ofNullable(clazz.cast(this.minVersion()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHubContentReferenceRequest, T> g) {
        return obj -> g.apply((CreateHubContentReferenceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String hubName;
        private String sageMakerPublicHubContentArn;
        private String hubContentName;
        private String minVersion;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHubContentReferenceRequest model) {
            super(model);
            this.hubName(model.hubName);
            this.sageMakerPublicHubContentArn(model.sageMakerPublicHubContentArn);
            this.hubContentName(model.hubContentName);
            this.minVersion(model.minVersion);
            this.tags(model.tags);
        }

        public final String getHubName() {
            return this.hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getSageMakerPublicHubContentArn() {
            return this.sageMakerPublicHubContentArn;
        }

        public final void setSageMakerPublicHubContentArn(String sageMakerPublicHubContentArn) {
            this.sageMakerPublicHubContentArn = sageMakerPublicHubContentArn;
        }

        @Override
        public final Builder sageMakerPublicHubContentArn(String sageMakerPublicHubContentArn) {
            this.sageMakerPublicHubContentArn = sageMakerPublicHubContentArn;
            return this;
        }

        public final String getHubContentName() {
            return this.hubContentName;
        }

        public final void setHubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
        }

        @Override
        public final Builder hubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
            return this;
        }

        public final String getMinVersion() {
            return this.minVersion;
        }

        public final void setMinVersion(String minVersion) {
            this.minVersion = minVersion;
        }

        @Override
        public final Builder minVersion(String minVersion) {
            this.minVersion = minVersion;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHubContentReferenceRequest build() {
            return new CreateHubContentReferenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHubContentReferenceRequest> {
        public Builder hubName(String var1);

        public Builder sageMakerPublicHubContentArn(String var1);

        public Builder hubContentName(String var1);

        public Builder minVersion(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

