/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstancePlacement;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceStatusDetails;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceType;
import software.amazon.awssdk.services.sagemaker.model.ClusterLifeCycleConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterNodeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterNodeDetails> {
    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceGroupName").getter(ClusterNodeDetails.getter(ClusterNodeDetails::instanceGroupName)).setter(ClusterNodeDetails.setter(Builder::instanceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ClusterNodeDetails.getter(ClusterNodeDetails::instanceId)).setter(ClusterNodeDetails.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<ClusterInstanceStatusDetails> INSTANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceStatus").getter(ClusterNodeDetails.getter(ClusterNodeDetails::instanceStatus)).setter(ClusterNodeDetails.setter(Builder::instanceStatus)).constructor(ClusterInstanceStatusDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatus").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ClusterNodeDetails.getter(ClusterNodeDetails::instanceTypeAsString)).setter(ClusterNodeDetails.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LaunchTime").getter(ClusterNodeDetails.getter(ClusterNodeDetails::launchTime)).setter(ClusterNodeDetails.setter(Builder::launchTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime").build()}).build();
    private static final SdkField<ClusterLifeCycleConfig> LIFE_CYCLE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LifeCycleConfig").getter(ClusterNodeDetails.getter(ClusterNodeDetails::lifeCycleConfig)).setter(ClusterNodeDetails.setter(Builder::lifeCycleConfig)).constructor(ClusterLifeCycleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleConfig").build()}).build();
    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThreadsPerCore").getter(ClusterNodeDetails.getter(ClusterNodeDetails::threadsPerCore)).setter(ClusterNodeDetails.setter(Builder::threadsPerCore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore").build()}).build();
    private static final SdkField<String> PRIVATE_PRIMARY_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivatePrimaryIp").getter(ClusterNodeDetails.getter(ClusterNodeDetails::privatePrimaryIp)).setter(ClusterNodeDetails.setter(Builder::privatePrimaryIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivatePrimaryIp").build()}).build();
    private static final SdkField<String> PRIVATE_DNS_HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateDnsHostname").getter(ClusterNodeDetails.getter(ClusterNodeDetails::privateDnsHostname)).setter(ClusterNodeDetails.setter(Builder::privateDnsHostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsHostname").build()}).build();
    private static final SdkField<ClusterInstancePlacement> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Placement").getter(ClusterNodeDetails.getter(ClusterNodeDetails::placement)).setter(ClusterNodeDetails.setter(Builder::placement)).constructor(ClusterInstancePlacement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_GROUP_NAME_FIELD, INSTANCE_ID_FIELD, INSTANCE_STATUS_FIELD, INSTANCE_TYPE_FIELD, LAUNCH_TIME_FIELD, LIFE_CYCLE_CONFIG_FIELD, THREADS_PER_CORE_FIELD, PRIVATE_PRIMARY_IP_FIELD, PRIVATE_DNS_HOSTNAME_FIELD, PLACEMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceGroupName;
    private final String instanceId;
    private final ClusterInstanceStatusDetails instanceStatus;
    private final String instanceType;
    private final Instant launchTime;
    private final ClusterLifeCycleConfig lifeCycleConfig;
    private final Integer threadsPerCore;
    private final String privatePrimaryIp;
    private final String privateDnsHostname;
    private final ClusterInstancePlacement placement;

    private ClusterNodeDetails(BuilderImpl builder) {
        this.instanceGroupName = builder.instanceGroupName;
        this.instanceId = builder.instanceId;
        this.instanceStatus = builder.instanceStatus;
        this.instanceType = builder.instanceType;
        this.launchTime = builder.launchTime;
        this.lifeCycleConfig = builder.lifeCycleConfig;
        this.threadsPerCore = builder.threadsPerCore;
        this.privatePrimaryIp = builder.privatePrimaryIp;
        this.privateDnsHostname = builder.privateDnsHostname;
        this.placement = builder.placement;
    }

    public final String instanceGroupName() {
        return this.instanceGroupName;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final ClusterInstanceStatusDetails instanceStatus() {
        return this.instanceStatus;
    }

    public final ClusterInstanceType instanceType() {
        return ClusterInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Instant launchTime() {
        return this.launchTime;
    }

    public final ClusterLifeCycleConfig lifeCycleConfig() {
        return this.lifeCycleConfig;
    }

    public final Integer threadsPerCore() {
        return this.threadsPerCore;
    }

    public final String privatePrimaryIp() {
        return this.privatePrimaryIp;
    }

    public final String privateDnsHostname() {
        return this.privateDnsHostname;
    }

    public final ClusterInstancePlacement placement() {
        return this.placement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.threadsPerCore());
        hashCode = 31 * hashCode + Objects.hashCode(this.privatePrimaryIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsHostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterNodeDetails)) {
            return false;
        }
        ClusterNodeDetails other = (ClusterNodeDetails)obj;
        return Objects.equals(this.instanceGroupName(), other.instanceGroupName()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceStatus(), other.instanceStatus()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.launchTime(), other.launchTime()) && Objects.equals(this.lifeCycleConfig(), other.lifeCycleConfig()) && Objects.equals(this.threadsPerCore(), other.threadsPerCore()) && Objects.equals(this.privatePrimaryIp(), other.privatePrimaryIp()) && Objects.equals(this.privateDnsHostname(), other.privateDnsHostname()) && Objects.equals(this.placement(), other.placement());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterNodeDetails").add("InstanceGroupName", (Object)this.instanceGroupName()).add("InstanceId", (Object)this.instanceId()).add("InstanceStatus", (Object)this.instanceStatus()).add("InstanceType", (Object)this.instanceTypeAsString()).add("LaunchTime", (Object)this.launchTime()).add("LifeCycleConfig", (Object)this.lifeCycleConfig()).add("ThreadsPerCore", (Object)this.threadsPerCore()).add("PrivatePrimaryIp", (Object)this.privatePrimaryIp()).add("PrivateDnsHostname", (Object)this.privateDnsHostname()).add("Placement", (Object)this.placement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceGroupName": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupName()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceStatus": {
                return Optional.ofNullable(clazz.cast(this.instanceStatus()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "LaunchTime": {
                return Optional.ofNullable(clazz.cast(this.launchTime()));
            }
            case "LifeCycleConfig": {
                return Optional.ofNullable(clazz.cast(this.lifeCycleConfig()));
            }
            case "ThreadsPerCore": {
                return Optional.ofNullable(clazz.cast(this.threadsPerCore()));
            }
            case "PrivatePrimaryIp": {
                return Optional.ofNullable(clazz.cast(this.privatePrimaryIp()));
            }
            case "PrivateDnsHostname": {
                return Optional.ofNullable(clazz.cast(this.privateDnsHostname()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterNodeDetails, T> g) {
        return obj -> g.apply((ClusterNodeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceGroupName;
        private String instanceId;
        private ClusterInstanceStatusDetails instanceStatus;
        private String instanceType;
        private Instant launchTime;
        private ClusterLifeCycleConfig lifeCycleConfig;
        private Integer threadsPerCore;
        private String privatePrimaryIp;
        private String privateDnsHostname;
        private ClusterInstancePlacement placement;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterNodeDetails model) {
            this.instanceGroupName(model.instanceGroupName);
            this.instanceId(model.instanceId);
            this.instanceStatus(model.instanceStatus);
            this.instanceType(model.instanceType);
            this.launchTime(model.launchTime);
            this.lifeCycleConfig(model.lifeCycleConfig);
            this.threadsPerCore(model.threadsPerCore);
            this.privatePrimaryIp(model.privatePrimaryIp);
            this.privateDnsHostname(model.privateDnsHostname);
            this.placement(model.placement);
        }

        public final String getInstanceGroupName() {
            return this.instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final ClusterInstanceStatusDetails.Builder getInstanceStatus() {
            return this.instanceStatus != null ? this.instanceStatus.toBuilder() : null;
        }

        public final void setInstanceStatus(ClusterInstanceStatusDetails.BuilderImpl instanceStatus) {
            this.instanceStatus = instanceStatus != null ? instanceStatus.build() : null;
        }

        @Override
        public final Builder instanceStatus(ClusterInstanceStatusDetails instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ClusterInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Instant getLaunchTime() {
            return this.launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final ClusterLifeCycleConfig.Builder getLifeCycleConfig() {
            return this.lifeCycleConfig != null ? this.lifeCycleConfig.toBuilder() : null;
        }

        public final void setLifeCycleConfig(ClusterLifeCycleConfig.BuilderImpl lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig != null ? lifeCycleConfig.build() : null;
        }

        @Override
        public final Builder lifeCycleConfig(ClusterLifeCycleConfig lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig;
            return this;
        }

        public final Integer getThreadsPerCore() {
            return this.threadsPerCore;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        public final String getPrivatePrimaryIp() {
            return this.privatePrimaryIp;
        }

        public final void setPrivatePrimaryIp(String privatePrimaryIp) {
            this.privatePrimaryIp = privatePrimaryIp;
        }

        @Override
        public final Builder privatePrimaryIp(String privatePrimaryIp) {
            this.privatePrimaryIp = privatePrimaryIp;
            return this;
        }

        public final String getPrivateDnsHostname() {
            return this.privateDnsHostname;
        }

        public final void setPrivateDnsHostname(String privateDnsHostname) {
            this.privateDnsHostname = privateDnsHostname;
        }

        @Override
        public final Builder privateDnsHostname(String privateDnsHostname) {
            this.privateDnsHostname = privateDnsHostname;
            return this;
        }

        public final ClusterInstancePlacement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        public final void setPlacement(ClusterInstancePlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(ClusterInstancePlacement placement) {
            this.placement = placement;
            return this;
        }

        public ClusterNodeDetails build() {
            return new ClusterNodeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterNodeDetails> {
        public Builder instanceGroupName(String var1);

        public Builder instanceId(String var1);

        public Builder instanceStatus(ClusterInstanceStatusDetails var1);

        default public Builder instanceStatus(Consumer<ClusterInstanceStatusDetails.Builder> instanceStatus) {
            return this.instanceStatus((ClusterInstanceStatusDetails)((ClusterInstanceStatusDetails.Builder)ClusterInstanceStatusDetails.builder().applyMutation(instanceStatus)).build());
        }

        public Builder instanceType(String var1);

        public Builder instanceType(ClusterInstanceType var1);

        public Builder launchTime(Instant var1);

        public Builder lifeCycleConfig(ClusterLifeCycleConfig var1);

        default public Builder lifeCycleConfig(Consumer<ClusterLifeCycleConfig.Builder> lifeCycleConfig) {
            return this.lifeCycleConfig((ClusterLifeCycleConfig)((ClusterLifeCycleConfig.Builder)ClusterLifeCycleConfig.builder().applyMutation(lifeCycleConfig)).build());
        }

        public Builder threadsPerCore(Integer var1);

        public Builder privatePrimaryIp(String var1);

        public Builder privateDnsHostname(String var1);

        public Builder placement(ClusterInstancePlacement var1);

        default public Builder placement(Consumer<ClusterInstancePlacement.Builder> placement) {
            return this.placement((ClusterInstancePlacement)((ClusterInstancePlacement.Builder)ClusterInstancePlacement.builder().applyMutation(placement)).build());
        }
    }
}

