/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AutoMLChannelType;
import software.amazon.awssdk.services.sagemaker.model.AutoMLDataSource;
import software.amazon.awssdk.services.sagemaker.model.CompressionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoMLChannel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoMLChannel> {
    private static final SdkField<AutoMLDataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSource").getter(AutoMLChannel.getter(AutoMLChannel::dataSource)).setter(AutoMLChannel.setter(Builder::dataSource)).constructor(AutoMLDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompressionType").getter(AutoMLChannel.getter(AutoMLChannel::compressionTypeAsString)).setter(AutoMLChannel.setter(Builder::compressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()}).build();
    private static final SdkField<String> TARGET_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetAttributeName").getter(AutoMLChannel.getter(AutoMLChannel::targetAttributeName)).setter(AutoMLChannel.setter(Builder::targetAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAttributeName").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(AutoMLChannel.getter(AutoMLChannel::contentType)).setter(AutoMLChannel.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<String> CHANNEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelType").getter(AutoMLChannel.getter(AutoMLChannel::channelTypeAsString)).setter(AutoMLChannel.setter(Builder::channelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelType").build()}).build();
    private static final SdkField<String> SAMPLE_WEIGHT_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SampleWeightAttributeName").getter(AutoMLChannel.getter(AutoMLChannel::sampleWeightAttributeName)).setter(AutoMLChannel.setter(Builder::sampleWeightAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleWeightAttributeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, COMPRESSION_TYPE_FIELD, TARGET_ATTRIBUTE_NAME_FIELD, CONTENT_TYPE_FIELD, CHANNEL_TYPE_FIELD, SAMPLE_WEIGHT_ATTRIBUTE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final AutoMLDataSource dataSource;
    private final String compressionType;
    private final String targetAttributeName;
    private final String contentType;
    private final String channelType;
    private final String sampleWeightAttributeName;

    private AutoMLChannel(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.compressionType = builder.compressionType;
        this.targetAttributeName = builder.targetAttributeName;
        this.contentType = builder.contentType;
        this.channelType = builder.channelType;
        this.sampleWeightAttributeName = builder.sampleWeightAttributeName;
    }

    public final AutoMLDataSource dataSource() {
        return this.dataSource;
    }

    public final CompressionType compressionType() {
        return CompressionType.fromValue(this.compressionType);
    }

    public final String compressionTypeAsString() {
        return this.compressionType;
    }

    public final String targetAttributeName() {
        return this.targetAttributeName;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final AutoMLChannelType channelType() {
        return AutoMLChannelType.fromValue(this.channelType);
    }

    public final String channelTypeAsString() {
        return this.channelType;
    }

    public final String sampleWeightAttributeName() {
        return this.sampleWeightAttributeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleWeightAttributeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLChannel)) {
            return false;
        }
        AutoMLChannel other = (AutoMLChannel)obj;
        return Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.compressionTypeAsString(), other.compressionTypeAsString()) && Objects.equals(this.targetAttributeName(), other.targetAttributeName()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.channelTypeAsString(), other.channelTypeAsString()) && Objects.equals(this.sampleWeightAttributeName(), other.sampleWeightAttributeName());
    }

    public final String toString() {
        return ToString.builder((String)"AutoMLChannel").add("DataSource", (Object)this.dataSource()).add("CompressionType", (Object)this.compressionTypeAsString()).add("TargetAttributeName", (Object)this.targetAttributeName()).add("ContentType", (Object)this.contentType()).add("ChannelType", (Object)this.channelTypeAsString()).add("SampleWeightAttributeName", (Object)this.sampleWeightAttributeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "CompressionType": {
                return Optional.ofNullable(clazz.cast(this.compressionTypeAsString()));
            }
            case "TargetAttributeName": {
                return Optional.ofNullable(clazz.cast(this.targetAttributeName()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "ChannelType": {
                return Optional.ofNullable(clazz.cast(this.channelTypeAsString()));
            }
            case "SampleWeightAttributeName": {
                return Optional.ofNullable(clazz.cast(this.sampleWeightAttributeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLChannel, T> g) {
        return obj -> g.apply((AutoMLChannel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutoMLDataSource dataSource;
        private String compressionType;
        private String targetAttributeName;
        private String contentType;
        private String channelType;
        private String sampleWeightAttributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLChannel model) {
            this.dataSource(model.dataSource);
            this.compressionType(model.compressionType);
            this.targetAttributeName(model.targetAttributeName);
            this.contentType(model.contentType);
            this.channelType(model.channelType);
            this.sampleWeightAttributeName(model.sampleWeightAttributeName);
        }

        public final AutoMLDataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(AutoMLDataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(AutoMLDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getCompressionType() {
            return this.compressionType;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(CompressionType compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        public final String getTargetAttributeName() {
            return this.targetAttributeName;
        }

        public final void setTargetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
        }

        @Override
        public final Builder targetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getChannelType() {
            return this.channelType;
        }

        public final void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        @Override
        public final Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        @Override
        public final Builder channelType(AutoMLChannelType channelType) {
            this.channelType(channelType == null ? null : channelType.toString());
            return this;
        }

        public final String getSampleWeightAttributeName() {
            return this.sampleWeightAttributeName;
        }

        public final void setSampleWeightAttributeName(String sampleWeightAttributeName) {
            this.sampleWeightAttributeName = sampleWeightAttributeName;
        }

        @Override
        public final Builder sampleWeightAttributeName(String sampleWeightAttributeName) {
            this.sampleWeightAttributeName = sampleWeightAttributeName;
            return this;
        }

        public AutoMLChannel build() {
            return new AutoMLChannel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoMLChannel> {
        public Builder dataSource(AutoMLDataSource var1);

        default public Builder dataSource(Consumer<AutoMLDataSource.Builder> dataSource) {
            return this.dataSource((AutoMLDataSource)((AutoMLDataSource.Builder)AutoMLDataSource.builder().applyMutation(dataSource)).build());
        }

        public Builder compressionType(String var1);

        public Builder compressionType(CompressionType var1);

        public Builder targetAttributeName(String var1);

        public Builder contentType(String var1);

        public Builder channelType(String var1);

        public Builder channelType(AutoMLChannelType var1);

        public Builder sampleWeightAttributeName(String var1);
    }
}

