/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinitionSummary;

public class ListModelBiasJobDefinitionsPublisher
implements SdkPublisher<ListModelBiasJobDefinitionsResponse> {
    private final SageMakerAsyncClient client;
    private final ListModelBiasJobDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelBiasJobDefinitionsPublisher(SageMakerAsyncClient client, ListModelBiasJobDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelBiasJobDefinitionsPublisher(SageMakerAsyncClient client, ListModelBiasJobDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelBiasJobDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelBiasJobDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MonitoringJobDefinitionSummary> jobDefinitionSummaries() {
        Function<ListModelBiasJobDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobDefinitionSummaries() != null) {
                return response.jobDefinitionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListModelBiasJobDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListModelBiasJobDefinitionsResponseFetcher
    implements AsyncPageFetcher<ListModelBiasJobDefinitionsResponse> {
        private ListModelBiasJobDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelBiasJobDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelBiasJobDefinitionsResponse> nextPage(ListModelBiasJobDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListModelBiasJobDefinitionsPublisher.this.client.listModelBiasJobDefinitions(ListModelBiasJobDefinitionsPublisher.this.firstRequest);
            }
            return ListModelBiasJobDefinitionsPublisher.this.client.listModelBiasJobDefinitions((ListModelBiasJobDefinitionsRequest)((Object)ListModelBiasJobDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

