/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesResponse;
import software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleSummary;

public class ListMonitoringSchedulesPublisher
implements SdkPublisher<ListMonitoringSchedulesResponse> {
    private final SageMakerAsyncClient client;
    private final ListMonitoringSchedulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMonitoringSchedulesPublisher(SageMakerAsyncClient client, ListMonitoringSchedulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMonitoringSchedulesPublisher(SageMakerAsyncClient client, ListMonitoringSchedulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMonitoringSchedulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMonitoringSchedulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MonitoringScheduleSummary> monitoringScheduleSummaries() {
        Function<ListMonitoringSchedulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.monitoringScheduleSummaries() != null) {
                return response.monitoringScheduleSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMonitoringSchedulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMonitoringSchedulesResponseFetcher
    implements AsyncPageFetcher<ListMonitoringSchedulesResponse> {
        private ListMonitoringSchedulesResponseFetcher() {
        }

        public boolean hasNextPage(ListMonitoringSchedulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMonitoringSchedulesResponse> nextPage(ListMonitoringSchedulesResponse previousPage) {
            if (previousPage == null) {
                return ListMonitoringSchedulesPublisher.this.client.listMonitoringSchedules(ListMonitoringSchedulesPublisher.this.firstRequest);
            }
            return ListMonitoringSchedulesPublisher.this.client.listMonitoringSchedules((ListMonitoringSchedulesRequest)((Object)ListMonitoringSchedulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

