/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AppType {
    JUPYTER_SERVER("JupyterServer"),
    KERNEL_GATEWAY("KernelGateway"),
    DETAILED_PROFILER("DetailedProfiler"),
    TENSOR_BOARD("TensorBoard"),
    VS_CODE("VSCode"),
    SAVITUR("Savitur"),
    CODE_EDITOR("CodeEditor"),
    JUPYTER_LAB("JupyterLab"),
    R_STUDIO_SERVER_PRO("RStudioServerPro"),
    R_SESSION("RSession"),
    R_SESSION_GATEWAY("RSessionGateway"),
    CANVAS("Canvas"),
    DATASET_MANAGER("DatasetManager"),
    SAGE_MAKER_LITE("SageMakerLite"),
    LOCAL("Local"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AppType> VALUE_MAP;
    private final String value;

    private AppType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AppType> knownValues() {
        EnumSet<AppType> knownValues = EnumSet.allOf(AppType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AppType.class, AppType::toString);
    }
}

