/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ProcessingJobSummary;

public class ListProcessingJobsIterable
implements SdkIterable<ListProcessingJobsResponse> {
    private final SageMakerClient client;
    private final ListProcessingJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProcessingJobsIterable(SageMakerClient client, ListProcessingJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProcessingJobsResponseFetcher();
    }

    public Iterator<ListProcessingJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProcessingJobSummary> processingJobSummaries() {
        Function<ListProcessingJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.processingJobSummaries() != null) {
                return response.processingJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProcessingJobsResponseFetcher
    implements SyncPageFetcher<ListProcessingJobsResponse> {
        private ListProcessingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListProcessingJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProcessingJobsResponse nextPage(ListProcessingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListProcessingJobsIterable.this.client.listProcessingJobs(ListProcessingJobsIterable.this.firstRequest);
            }
            return ListProcessingJobsIterable.this.client.listProcessingJobs((ListProcessingJobsRequest)((Object)ListProcessingJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

