/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3DataDistribution {
    FULLY_REPLICATED("FullyReplicated"),
    SHARDED_BY_S3_KEY("ShardedByS3Key"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3DataDistribution> VALUE_MAP;
    private final String value;

    private S3DataDistribution(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3DataDistribution fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3DataDistribution> knownValues() {
        EnumSet<S3DataDistribution> knownValues = EnumSet.allOf(S3DataDistribution.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3DataDistribution.class, S3DataDistribution::toString);
    }
}

