/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataQualityJobDefinitionRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateDataQualityJobDefinitionRequest.Builder, CreateDataQualityJobDefinitionRequest> {
    private static final SdkField<String> JOB_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobDefinitionName").getter(getter(CreateDataQualityJobDefinitionRequest::jobDefinitionName))
            .setter(setter(Builder::jobDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionName").build()).build();

    private static final SdkField<DataQualityBaselineConfig> DATA_QUALITY_BASELINE_CONFIG_FIELD = SdkField
            .<DataQualityBaselineConfig> builder(MarshallingType.SDK_POJO).memberName("DataQualityBaselineConfig")
            .getter(getter(CreateDataQualityJobDefinitionRequest::dataQualityBaselineConfig))
            .setter(setter(Builder::dataQualityBaselineConfig)).constructor(DataQualityBaselineConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityBaselineConfig").build())
            .build();

    private static final SdkField<DataQualityAppSpecification> DATA_QUALITY_APP_SPECIFICATION_FIELD = SdkField
            .<DataQualityAppSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("DataQualityAppSpecification")
            .getter(getter(CreateDataQualityJobDefinitionRequest::dataQualityAppSpecification))
            .setter(setter(Builder::dataQualityAppSpecification))
            .constructor(DataQualityAppSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityAppSpecification")
                    .build()).build();

    private static final SdkField<DataQualityJobInput> DATA_QUALITY_JOB_INPUT_FIELD = SdkField
            .<DataQualityJobInput> builder(MarshallingType.SDK_POJO).memberName("DataQualityJobInput")
            .getter(getter(CreateDataQualityJobDefinitionRequest::dataQualityJobInput))
            .setter(setter(Builder::dataQualityJobInput)).constructor(DataQualityJobInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityJobInput").build())
            .build();

    private static final SdkField<MonitoringOutputConfig> DATA_QUALITY_JOB_OUTPUT_CONFIG_FIELD = SdkField
            .<MonitoringOutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("DataQualityJobOutputConfig")
            .getter(getter(CreateDataQualityJobDefinitionRequest::dataQualityJobOutputConfig))
            .setter(setter(Builder::dataQualityJobOutputConfig))
            .constructor(MonitoringOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualityJobOutputConfig").build())
            .build();

    private static final SdkField<MonitoringResources> JOB_RESOURCES_FIELD = SdkField
            .<MonitoringResources> builder(MarshallingType.SDK_POJO).memberName("JobResources")
            .getter(getter(CreateDataQualityJobDefinitionRequest::jobResources)).setter(setter(Builder::jobResources))
            .constructor(MonitoringResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobResources").build()).build();

    private static final SdkField<MonitoringNetworkConfig> NETWORK_CONFIG_FIELD = SdkField
            .<MonitoringNetworkConfig> builder(MarshallingType.SDK_POJO).memberName("NetworkConfig")
            .getter(getter(CreateDataQualityJobDefinitionRequest::networkConfig)).setter(setter(Builder::networkConfig))
            .constructor(MonitoringNetworkConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateDataQualityJobDefinitionRequest::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<MonitoringStoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<MonitoringStoppingCondition> builder(MarshallingType.SDK_POJO).memberName("StoppingCondition")
            .getter(getter(CreateDataQualityJobDefinitionRequest::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(MonitoringStoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDataQualityJobDefinitionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_DEFINITION_NAME_FIELD,
            DATA_QUALITY_BASELINE_CONFIG_FIELD, DATA_QUALITY_APP_SPECIFICATION_FIELD, DATA_QUALITY_JOB_INPUT_FIELD,
            DATA_QUALITY_JOB_OUTPUT_CONFIG_FIELD, JOB_RESOURCES_FIELD, NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD,
            STOPPING_CONDITION_FIELD, TAGS_FIELD));

    private final String jobDefinitionName;

    private final DataQualityBaselineConfig dataQualityBaselineConfig;

    private final DataQualityAppSpecification dataQualityAppSpecification;

    private final DataQualityJobInput dataQualityJobInput;

    private final MonitoringOutputConfig dataQualityJobOutputConfig;

    private final MonitoringResources jobResources;

    private final MonitoringNetworkConfig networkConfig;

    private final String roleArn;

    private final MonitoringStoppingCondition stoppingCondition;

    private final List<Tag> tags;

    private CreateDataQualityJobDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionName = builder.jobDefinitionName;
        this.dataQualityBaselineConfig = builder.dataQualityBaselineConfig;
        this.dataQualityAppSpecification = builder.dataQualityAppSpecification;
        this.dataQualityJobInput = builder.dataQualityJobInput;
        this.dataQualityJobOutputConfig = builder.dataQualityJobOutputConfig;
        this.jobResources = builder.jobResources;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name for the monitoring job definition.
     * </p>
     * 
     * @return The name for the monitoring job definition.
     */
    public final String jobDefinitionName() {
        return jobDefinitionName;
    }

    /**
     * <p>
     * Configures the constraints and baselines for the monitoring job.
     * </p>
     * 
     * @return Configures the constraints and baselines for the monitoring job.
     */
    public final DataQualityBaselineConfig dataQualityBaselineConfig() {
        return dataQualityBaselineConfig;
    }

    /**
     * <p>
     * Specifies the container that runs the monitoring job.
     * </p>
     * 
     * @return Specifies the container that runs the monitoring job.
     */
    public final DataQualityAppSpecification dataQualityAppSpecification() {
        return dataQualityAppSpecification;
    }

    /**
     * <p>
     * A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.
     * </p>
     * 
     * @return A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.
     */
    public final DataQualityJobInput dataQualityJobInput() {
        return dataQualityJobInput;
    }

    /**
     * Returns the value of the DataQualityJobOutputConfig property for this object.
     * 
     * @return The value of the DataQualityJobOutputConfig property for this object.
     */
    public final MonitoringOutputConfig dataQualityJobOutputConfig() {
        return dataQualityJobOutputConfig;
    }

    /**
     * Returns the value of the JobResources property for this object.
     * 
     * @return The value of the JobResources property for this object.
     */
    public final MonitoringResources jobResources() {
        return jobResources;
    }

    /**
     * <p>
     * Specifies networking configuration for the monitoring job.
     * </p>
     * 
     * @return Specifies networking configuration for the monitoring job.
     */
    public final MonitoringNetworkConfig networkConfig() {
        return networkConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
     *         behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the StoppingCondition property for this object.
     * 
     * @return The value of the StoppingCondition property for this object.
     */
    public final MonitoringStoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Optional) An array of key-value pairs. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using
     * Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return (Optional) An array of key-value pairs. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
     *         >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(dataQualityBaselineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(dataQualityAppSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(dataQualityJobInput());
        hashCode = 31 * hashCode + Objects.hashCode(dataQualityJobOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobResources());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataQualityJobDefinitionRequest)) {
            return false;
        }
        CreateDataQualityJobDefinitionRequest other = (CreateDataQualityJobDefinitionRequest) obj;
        return Objects.equals(jobDefinitionName(), other.jobDefinitionName())
                && Objects.equals(dataQualityBaselineConfig(), other.dataQualityBaselineConfig())
                && Objects.equals(dataQualityAppSpecification(), other.dataQualityAppSpecification())
                && Objects.equals(dataQualityJobInput(), other.dataQualityJobInput())
                && Objects.equals(dataQualityJobOutputConfig(), other.dataQualityJobOutputConfig())
                && Objects.equals(jobResources(), other.jobResources()) && Objects.equals(networkConfig(), other.networkConfig())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(stoppingCondition(), other.stoppingCondition())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataQualityJobDefinitionRequest").add("JobDefinitionName", jobDefinitionName())
                .add("DataQualityBaselineConfig", dataQualityBaselineConfig())
                .add("DataQualityAppSpecification", dataQualityAppSpecification())
                .add("DataQualityJobInput", dataQualityJobInput())
                .add("DataQualityJobOutputConfig", dataQualityJobOutputConfig()).add("JobResources", jobResources())
                .add("NetworkConfig", networkConfig()).add("RoleArn", roleArn()).add("StoppingCondition", stoppingCondition())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobDefinitionName":
            return Optional.ofNullable(clazz.cast(jobDefinitionName()));
        case "DataQualityBaselineConfig":
            return Optional.ofNullable(clazz.cast(dataQualityBaselineConfig()));
        case "DataQualityAppSpecification":
            return Optional.ofNullable(clazz.cast(dataQualityAppSpecification()));
        case "DataQualityJobInput":
            return Optional.ofNullable(clazz.cast(dataQualityJobInput()));
        case "DataQualityJobOutputConfig":
            return Optional.ofNullable(clazz.cast(dataQualityJobOutputConfig()));
        case "JobResources":
            return Optional.ofNullable(clazz.cast(jobResources()));
        case "NetworkConfig":
            return Optional.ofNullable(clazz.cast(networkConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataQualityJobDefinitionRequest, T> g) {
        return obj -> g.apply((CreateDataQualityJobDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataQualityJobDefinitionRequest> {
        /**
         * <p>
         * The name for the monitoring job definition.
         * </p>
         * 
         * @param jobDefinitionName
         *        The name for the monitoring job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionName(String jobDefinitionName);

        /**
         * <p>
         * Configures the constraints and baselines for the monitoring job.
         * </p>
         * 
         * @param dataQualityBaselineConfig
         *        Configures the constraints and baselines for the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQualityBaselineConfig(DataQualityBaselineConfig dataQualityBaselineConfig);

        /**
         * <p>
         * Configures the constraints and baselines for the monitoring job.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataQualityBaselineConfig.Builder}
         * avoiding the need to create one manually via {@link DataQualityBaselineConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataQualityBaselineConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #dataQualityBaselineConfig(DataQualityBaselineConfig)}.
         * 
         * @param dataQualityBaselineConfig
         *        a consumer that will call methods on {@link DataQualityBaselineConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataQualityBaselineConfig(DataQualityBaselineConfig)
         */
        default Builder dataQualityBaselineConfig(Consumer<DataQualityBaselineConfig.Builder> dataQualityBaselineConfig) {
            return dataQualityBaselineConfig(DataQualityBaselineConfig.builder().applyMutation(dataQualityBaselineConfig).build());
        }

        /**
         * <p>
         * Specifies the container that runs the monitoring job.
         * </p>
         * 
         * @param dataQualityAppSpecification
         *        Specifies the container that runs the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQualityAppSpecification(DataQualityAppSpecification dataQualityAppSpecification);

        /**
         * <p>
         * Specifies the container that runs the monitoring job.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataQualityAppSpecification.Builder}
         * avoiding the need to create one manually via {@link DataQualityAppSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataQualityAppSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #dataQualityAppSpecification(DataQualityAppSpecification)}.
         * 
         * @param dataQualityAppSpecification
         *        a consumer that will call methods on {@link DataQualityAppSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataQualityAppSpecification(DataQualityAppSpecification)
         */
        default Builder dataQualityAppSpecification(Consumer<DataQualityAppSpecification.Builder> dataQualityAppSpecification) {
            return dataQualityAppSpecification(DataQualityAppSpecification.builder().applyMutation(dataQualityAppSpecification)
                    .build());
        }

        /**
         * <p>
         * A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.
         * </p>
         * 
         * @param dataQualityJobInput
         *        A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQualityJobInput(DataQualityJobInput dataQualityJobInput);

        /**
         * <p>
         * A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataQualityJobInput.Builder} avoiding the
         * need to create one manually via {@link DataQualityJobInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataQualityJobInput.Builder#build()} is called immediately and
         * its result is passed to {@link #dataQualityJobInput(DataQualityJobInput)}.
         * 
         * @param dataQualityJobInput
         *        a consumer that will call methods on {@link DataQualityJobInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataQualityJobInput(DataQualityJobInput)
         */
        default Builder dataQualityJobInput(Consumer<DataQualityJobInput.Builder> dataQualityJobInput) {
            return dataQualityJobInput(DataQualityJobInput.builder().applyMutation(dataQualityJobInput).build());
        }

        /**
         * Sets the value of the DataQualityJobOutputConfig property for this object.
         *
         * @param dataQualityJobOutputConfig
         *        The new value for the DataQualityJobOutputConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataQualityJobOutputConfig(MonitoringOutputConfig dataQualityJobOutputConfig);

        /**
         * Sets the value of the DataQualityJobOutputConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MonitoringOutputConfig.Builder} avoiding
         * the need to create one manually via {@link MonitoringOutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #dataQualityJobOutputConfig(MonitoringOutputConfig)}.
         * 
         * @param dataQualityJobOutputConfig
         *        a consumer that will call methods on {@link MonitoringOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataQualityJobOutputConfig(MonitoringOutputConfig)
         */
        default Builder dataQualityJobOutputConfig(Consumer<MonitoringOutputConfig.Builder> dataQualityJobOutputConfig) {
            return dataQualityJobOutputConfig(MonitoringOutputConfig.builder().applyMutation(dataQualityJobOutputConfig).build());
        }

        /**
         * Sets the value of the JobResources property for this object.
         *
         * @param jobResources
         *        The new value for the JobResources property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobResources(MonitoringResources jobResources);

        /**
         * Sets the value of the JobResources property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MonitoringResources.Builder} avoiding the
         * need to create one manually via {@link MonitoringResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringResources.Builder#build()} is called immediately and
         * its result is passed to {@link #jobResources(MonitoringResources)}.
         * 
         * @param jobResources
         *        a consumer that will call methods on {@link MonitoringResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobResources(MonitoringResources)
         */
        default Builder jobResources(Consumer<MonitoringResources.Builder> jobResources) {
            return jobResources(MonitoringResources.builder().applyMutation(jobResources).build());
        }

        /**
         * <p>
         * Specifies networking configuration for the monitoring job.
         * </p>
         * 
         * @param networkConfig
         *        Specifies networking configuration for the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfig(MonitoringNetworkConfig networkConfig);

        /**
         * <p>
         * Specifies networking configuration for the monitoring job.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonitoringNetworkConfig.Builder} avoiding
         * the need to create one manually via {@link MonitoringNetworkConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringNetworkConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #networkConfig(MonitoringNetworkConfig)}.
         * 
         * @param networkConfig
         *        a consumer that will call methods on {@link MonitoringNetworkConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfig(MonitoringNetworkConfig)
         */
        default Builder networkConfig(Consumer<MonitoringNetworkConfig.Builder> networkConfig) {
            return networkConfig(MonitoringNetworkConfig.builder().applyMutation(networkConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
         * behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
         *        your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * @param stoppingCondition
         *        The new value for the StoppingCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition);

        /**
         * Sets the value of the StoppingCondition property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MonitoringStoppingCondition.Builder}
         * avoiding the need to create one manually via {@link MonitoringStoppingCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonitoringStoppingCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #stoppingCondition(MonitoringStoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link MonitoringStoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(MonitoringStoppingCondition)
         */
        default Builder stoppingCondition(Consumer<MonitoringStoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(MonitoringStoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         * >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        (Optional) An array of key-value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         *        >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         * >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        (Optional) An array of key-value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         *        >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         * >Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String jobDefinitionName;

        private DataQualityBaselineConfig dataQualityBaselineConfig;

        private DataQualityAppSpecification dataQualityAppSpecification;

        private DataQualityJobInput dataQualityJobInput;

        private MonitoringOutputConfig dataQualityJobOutputConfig;

        private MonitoringResources jobResources;

        private MonitoringNetworkConfig networkConfig;

        private String roleArn;

        private MonitoringStoppingCondition stoppingCondition;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataQualityJobDefinitionRequest model) {
            super(model);
            jobDefinitionName(model.jobDefinitionName);
            dataQualityBaselineConfig(model.dataQualityBaselineConfig);
            dataQualityAppSpecification(model.dataQualityAppSpecification);
            dataQualityJobInput(model.dataQualityJobInput);
            dataQualityJobOutputConfig(model.dataQualityJobOutputConfig);
            jobResources(model.jobResources);
            networkConfig(model.networkConfig);
            roleArn(model.roleArn);
            stoppingCondition(model.stoppingCondition);
            tags(model.tags);
        }

        public final String getJobDefinitionName() {
            return jobDefinitionName;
        }

        public final void setJobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
        }

        @Override
        public final Builder jobDefinitionName(String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        public final DataQualityBaselineConfig.Builder getDataQualityBaselineConfig() {
            return dataQualityBaselineConfig != null ? dataQualityBaselineConfig.toBuilder() : null;
        }

        public final void setDataQualityBaselineConfig(DataQualityBaselineConfig.BuilderImpl dataQualityBaselineConfig) {
            this.dataQualityBaselineConfig = dataQualityBaselineConfig != null ? dataQualityBaselineConfig.build() : null;
        }

        @Override
        public final Builder dataQualityBaselineConfig(DataQualityBaselineConfig dataQualityBaselineConfig) {
            this.dataQualityBaselineConfig = dataQualityBaselineConfig;
            return this;
        }

        public final DataQualityAppSpecification.Builder getDataQualityAppSpecification() {
            return dataQualityAppSpecification != null ? dataQualityAppSpecification.toBuilder() : null;
        }

        public final void setDataQualityAppSpecification(DataQualityAppSpecification.BuilderImpl dataQualityAppSpecification) {
            this.dataQualityAppSpecification = dataQualityAppSpecification != null ? dataQualityAppSpecification.build() : null;
        }

        @Override
        public final Builder dataQualityAppSpecification(DataQualityAppSpecification dataQualityAppSpecification) {
            this.dataQualityAppSpecification = dataQualityAppSpecification;
            return this;
        }

        public final DataQualityJobInput.Builder getDataQualityJobInput() {
            return dataQualityJobInput != null ? dataQualityJobInput.toBuilder() : null;
        }

        public final void setDataQualityJobInput(DataQualityJobInput.BuilderImpl dataQualityJobInput) {
            this.dataQualityJobInput = dataQualityJobInput != null ? dataQualityJobInput.build() : null;
        }

        @Override
        public final Builder dataQualityJobInput(DataQualityJobInput dataQualityJobInput) {
            this.dataQualityJobInput = dataQualityJobInput;
            return this;
        }

        public final MonitoringOutputConfig.Builder getDataQualityJobOutputConfig() {
            return dataQualityJobOutputConfig != null ? dataQualityJobOutputConfig.toBuilder() : null;
        }

        public final void setDataQualityJobOutputConfig(MonitoringOutputConfig.BuilderImpl dataQualityJobOutputConfig) {
            this.dataQualityJobOutputConfig = dataQualityJobOutputConfig != null ? dataQualityJobOutputConfig.build() : null;
        }

        @Override
        public final Builder dataQualityJobOutputConfig(MonitoringOutputConfig dataQualityJobOutputConfig) {
            this.dataQualityJobOutputConfig = dataQualityJobOutputConfig;
            return this;
        }

        public final MonitoringResources.Builder getJobResources() {
            return jobResources != null ? jobResources.toBuilder() : null;
        }

        public final void setJobResources(MonitoringResources.BuilderImpl jobResources) {
            this.jobResources = jobResources != null ? jobResources.build() : null;
        }

        @Override
        public final Builder jobResources(MonitoringResources jobResources) {
            this.jobResources = jobResources;
            return this;
        }

        public final MonitoringNetworkConfig.Builder getNetworkConfig() {
            return networkConfig != null ? networkConfig.toBuilder() : null;
        }

        public final void setNetworkConfig(MonitoringNetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        @Override
        public final Builder networkConfig(MonitoringNetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final MonitoringStoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(MonitoringStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(MonitoringStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataQualityJobDefinitionRequest build() {
            return new CreateDataQualityJobDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
