/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.MetricSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetTrackingScalingPolicyConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetTrackingScalingPolicyConfiguration> {
    private static final SdkField<MetricSpecification> METRIC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetricSpecification").getter(TargetTrackingScalingPolicyConfiguration.getter(TargetTrackingScalingPolicyConfiguration::metricSpecification)).setter(TargetTrackingScalingPolicyConfiguration.setter(Builder::metricSpecification)).constructor(MetricSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSpecification").build()}).build();
    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TargetValue").getter(TargetTrackingScalingPolicyConfiguration.getter(TargetTrackingScalingPolicyConfiguration::targetValue)).setter(TargetTrackingScalingPolicyConfiguration.setter(Builder::targetValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_SPECIFICATION_FIELD, TARGET_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final MetricSpecification metricSpecification;
    private final Double targetValue;

    private TargetTrackingScalingPolicyConfiguration(BuilderImpl builder) {
        this.metricSpecification = builder.metricSpecification;
        this.targetValue = builder.targetValue;
    }

    public final MetricSpecification metricSpecification() {
        return this.metricSpecification;
    }

    public final Double targetValue() {
        return this.targetValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingScalingPolicyConfiguration)) {
            return false;
        }
        TargetTrackingScalingPolicyConfiguration other = (TargetTrackingScalingPolicyConfiguration)obj;
        return Objects.equals(this.metricSpecification(), other.metricSpecification()) && Objects.equals(this.targetValue(), other.targetValue());
    }

    public final String toString() {
        return ToString.builder((String)"TargetTrackingScalingPolicyConfiguration").add("MetricSpecification", (Object)this.metricSpecification()).add("TargetValue", (Object)this.targetValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricSpecification": {
                return Optional.ofNullable(clazz.cast(this.metricSpecification()));
            }
            case "TargetValue": {
                return Optional.ofNullable(clazz.cast(this.targetValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetTrackingScalingPolicyConfiguration, T> g) {
        return obj -> g.apply((TargetTrackingScalingPolicyConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MetricSpecification metricSpecification;
        private Double targetValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingScalingPolicyConfiguration model) {
            this.metricSpecification(model.metricSpecification);
            this.targetValue(model.targetValue);
        }

        public final MetricSpecification.Builder getMetricSpecification() {
            return this.metricSpecification != null ? this.metricSpecification.toBuilder() : null;
        }

        public final void setMetricSpecification(MetricSpecification.BuilderImpl metricSpecification) {
            this.metricSpecification = metricSpecification != null ? metricSpecification.build() : null;
        }

        @Override
        public final Builder metricSpecification(MetricSpecification metricSpecification) {
            this.metricSpecification = metricSpecification;
            return this;
        }

        public final Double getTargetValue() {
            return this.targetValue;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public TargetTrackingScalingPolicyConfiguration build() {
            return new TargetTrackingScalingPolicyConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetTrackingScalingPolicyConfiguration> {
        public Builder metricSpecification(MetricSpecification var1);

        default public Builder metricSpecification(Consumer<MetricSpecification.Builder> metricSpecification) {
            return this.metricSpecification((MetricSpecification)((MetricSpecification.Builder)MetricSpecification.builder().applyMutation(metricSpecification)).build());
        }

        public Builder targetValue(Double var1);
    }
}

