/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DetailedModelPackageStatus {
    NOT_STARTED("NotStarted"),
    IN_PROGRESS("InProgress"),
    COMPLETED("Completed"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DetailedModelPackageStatus> VALUE_MAP;
    private final String value;

    private DetailedModelPackageStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DetailedModelPackageStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DetailedModelPackageStatus> knownValues() {
        EnumSet<DetailedModelPackageStatus> knownValues = EnumSet.allOf(DetailedModelPackageStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DetailedModelPackageStatus.class, DetailedModelPackageStatus::toString);
    }
}

