/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.ActionStatus;
import software.amazon.awssdk.services.sagemaker.model.LineageEntityParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.ListLineageEntityParameterKeyCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateActionRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateActionRequest> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionName").getter(UpdateActionRequest.getter(UpdateActionRequest::actionName)).setter(UpdateActionRequest.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateActionRequest.getter(UpdateActionRequest::description)).setter(UpdateActionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UpdateActionRequest.getter(UpdateActionRequest::statusAsString)).setter(UpdateActionRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Properties").getter(UpdateActionRequest.getter(UpdateActionRequest::properties)).setter(UpdateActionRequest.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PROPERTIES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PropertiesToRemove").getter(UpdateActionRequest.getter(UpdateActionRequest::propertiesToRemove)).setter(UpdateActionRequest.setter(Builder::propertiesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertiesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, PROPERTIES_FIELD, PROPERTIES_TO_REMOVE_FIELD));
    private final String actionName;
    private final String description;
    private final String status;
    private final Map<String, String> properties;
    private final List<String> propertiesToRemove;

    private UpdateActionRequest(BuilderImpl builder) {
        super(builder);
        this.actionName = builder.actionName;
        this.description = builder.description;
        this.status = builder.status;
        this.properties = builder.properties;
        this.propertiesToRemove = builder.propertiesToRemove;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final String description() {
        return this.description;
    }

    public final ActionStatus status() {
        return ActionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> properties() {
        return this.properties;
    }

    public final boolean hasPropertiesToRemove() {
        return this.propertiesToRemove != null && !(this.propertiesToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> propertiesToRemove() {
        return this.propertiesToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertiesToRemove() ? this.propertiesToRemove() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateActionRequest)) {
            return false;
        }
        UpdateActionRequest other = (UpdateActionRequest)((Object)obj);
        return Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && this.hasPropertiesToRemove() == other.hasPropertiesToRemove() && Objects.equals(this.propertiesToRemove(), other.propertiesToRemove());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateActionRequest").add("ActionName", (Object)this.actionName()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("Properties", this.hasProperties() ? this.properties() : null).add("PropertiesToRemove", this.hasPropertiesToRemove() ? this.propertiesToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "PropertiesToRemove": {
                return Optional.ofNullable(clazz.cast(this.propertiesToRemove()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateActionRequest, T> g) {
        return obj -> g.apply((UpdateActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String actionName;
        private String description;
        private String status;
        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();
        private List<String> propertiesToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateActionRequest model) {
            super(model);
            this.actionName(model.actionName);
            this.description(model.description);
            this.status(model.status);
            this.properties(model.properties);
            this.propertiesToRemove(model.propertiesToRemove);
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        @Transient
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getProperties() {
            if (this.properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
        }

        @Override
        @Transient
        public final Builder properties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
            return this;
        }

        public final Collection<String> getPropertiesToRemove() {
            if (this.propertiesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.propertiesToRemove;
        }

        public final void setPropertiesToRemove(Collection<String> propertiesToRemove) {
            this.propertiesToRemove = ListLineageEntityParameterKeyCopier.copy(propertiesToRemove);
        }

        @Override
        @Transient
        public final Builder propertiesToRemove(Collection<String> propertiesToRemove) {
            this.propertiesToRemove = ListLineageEntityParameterKeyCopier.copy(propertiesToRemove);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder propertiesToRemove(String ... propertiesToRemove) {
            this.propertiesToRemove(Arrays.asList(propertiesToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateActionRequest build() {
            return new UpdateActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateActionRequest> {
        public Builder actionName(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(ActionStatus var1);

        public Builder properties(Map<String, String> var1);

        public Builder propertiesToRemove(Collection<String> var1);

        public Builder propertiesToRemove(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

