/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.RenderingError;
import software.amazon.awssdk.services.sagemaker.model.RenderingErrorListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RenderUiTemplateResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, RenderUiTemplateResponse> {
    private static final SdkField<String> RENDERED_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RenderedContent").getter(RenderUiTemplateResponse.getter(RenderUiTemplateResponse::renderedContent)).setter(RenderUiTemplateResponse.setter(Builder::renderedContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenderedContent").build()}).build();
    private static final SdkField<List<RenderingError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(RenderUiTemplateResponse.getter(RenderUiTemplateResponse::errors)).setter(RenderUiTemplateResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RenderingError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENDERED_CONTENT_FIELD, ERRORS_FIELD));
    private final String renderedContent;
    private final List<RenderingError> errors;

    private RenderUiTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.renderedContent = builder.renderedContent;
        this.errors = builder.errors;
    }

    public final String renderedContent() {
        return this.renderedContent;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<RenderingError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.renderedContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RenderUiTemplateResponse)) {
            return false;
        }
        RenderUiTemplateResponse other = (RenderUiTemplateResponse)((Object)obj);
        return Objects.equals(this.renderedContent(), other.renderedContent()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"RenderUiTemplateResponse").add("RenderedContent", (Object)this.renderedContent()).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RenderedContent": {
                return Optional.ofNullable(clazz.cast(this.renderedContent()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RenderUiTemplateResponse, T> g) {
        return obj -> g.apply((RenderUiTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String renderedContent;
        private List<RenderingError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RenderUiTemplateResponse model) {
            super(model);
            this.renderedContent(model.renderedContent);
            this.errors(model.errors);
        }

        public final String getRenderedContent() {
            return this.renderedContent;
        }

        public final void setRenderedContent(String renderedContent) {
            this.renderedContent = renderedContent;
        }

        @Override
        @Transient
        public final Builder renderedContent(String renderedContent) {
            this.renderedContent = renderedContent;
            return this;
        }

        public final List<RenderingError.Builder> getErrors() {
            List<RenderingError.Builder> result = RenderingErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<RenderingError.BuilderImpl> errors) {
            this.errors = RenderingErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        @Transient
        public final Builder errors(Collection<RenderingError> errors) {
            this.errors = RenderingErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errors(RenderingError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errors(Consumer<RenderingError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (RenderingError)((RenderingError.Builder)RenderingError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RenderUiTemplateResponse build() {
            return new RenderUiTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RenderUiTemplateResponse> {
        public Builder renderedContent(String var1);

        public Builder errors(Collection<RenderingError> var1);

        public Builder errors(RenderingError ... var1);

        public Builder errors(Consumer<RenderingError.Builder> ... var1);
    }
}

