/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.AsyncInferenceNotificationConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AsyncInferenceOutputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AsyncInferenceOutputConfig> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(AsyncInferenceOutputConfig.getter(AsyncInferenceOutputConfig::kmsKeyId)).setter(AsyncInferenceOutputConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3OutputPath").getter(AsyncInferenceOutputConfig.getter(AsyncInferenceOutputConfig::s3OutputPath)).setter(AsyncInferenceOutputConfig.setter(Builder::s3OutputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()}).build();
    private static final SdkField<AsyncInferenceNotificationConfig> NOTIFICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationConfig").getter(AsyncInferenceOutputConfig.getter(AsyncInferenceOutputConfig::notificationConfig)).setter(AsyncInferenceOutputConfig.setter(Builder::notificationConfig)).constructor(AsyncInferenceNotificationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD, S3_OUTPUT_PATH_FIELD, NOTIFICATION_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String kmsKeyId;
    private final String s3OutputPath;
    private final AsyncInferenceNotificationConfig notificationConfig;

    private AsyncInferenceOutputConfig(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.s3OutputPath = builder.s3OutputPath;
        this.notificationConfig = builder.notificationConfig;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String s3OutputPath() {
        return this.s3OutputPath;
    }

    public final AsyncInferenceNotificationConfig notificationConfig() {
        return this.notificationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsyncInferenceOutputConfig)) {
            return false;
        }
        AsyncInferenceOutputConfig other = (AsyncInferenceOutputConfig)obj;
        return Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.s3OutputPath(), other.s3OutputPath()) && Objects.equals(this.notificationConfig(), other.notificationConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AsyncInferenceOutputConfig").add("KmsKeyId", (Object)this.kmsKeyId()).add("S3OutputPath", (Object)this.s3OutputPath()).add("NotificationConfig", (Object)this.notificationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "S3OutputPath": {
                return Optional.ofNullable(clazz.cast(this.s3OutputPath()));
            }
            case "NotificationConfig": {
                return Optional.ofNullable(clazz.cast(this.notificationConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AsyncInferenceOutputConfig, T> g) {
        return obj -> g.apply((AsyncInferenceOutputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyId;
        private String s3OutputPath;
        private AsyncInferenceNotificationConfig notificationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AsyncInferenceOutputConfig model) {
            this.kmsKeyId(model.kmsKeyId);
            this.s3OutputPath(model.s3OutputPath);
            this.notificationConfig(model.notificationConfig);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getS3OutputPath() {
            return this.s3OutputPath;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        @Override
        @Transient
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final AsyncInferenceNotificationConfig.Builder getNotificationConfig() {
            return this.notificationConfig != null ? this.notificationConfig.toBuilder() : null;
        }

        public final void setNotificationConfig(AsyncInferenceNotificationConfig.BuilderImpl notificationConfig) {
            this.notificationConfig = notificationConfig != null ? notificationConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder notificationConfig(AsyncInferenceNotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public AsyncInferenceOutputConfig build() {
            return new AsyncInferenceOutputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AsyncInferenceOutputConfig> {
        public Builder kmsKeyId(String var1);

        public Builder s3OutputPath(String var1);

        public Builder notificationConfig(AsyncInferenceNotificationConfig var1);

        default public Builder notificationConfig(Consumer<AsyncInferenceNotificationConfig.Builder> notificationConfig) {
            return this.notificationConfig((AsyncInferenceNotificationConfig)((AsyncInferenceNotificationConfig.Builder)AsyncInferenceNotificationConfig.builder().applyMutation(notificationConfig)).build());
        }
    }
}

