/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ContextSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContextSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContextSummary> {
    private static final SdkField<String> CONTEXT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContextArn").getter(ContextSummary.getter(ContextSummary::contextArn)).setter(ContextSummary.setter(Builder::contextArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextArn").build()}).build();
    private static final SdkField<String> CONTEXT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContextName").getter(ContextSummary.getter(ContextSummary::contextName)).setter(ContextSummary.setter(Builder::contextName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextName").build()}).build();
    private static final SdkField<ContextSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(ContextSummary.getter(ContextSummary::source)).setter(ContextSummary.setter(Builder::source)).constructor(ContextSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> CONTEXT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContextType").getter(ContextSummary.getter(ContextSummary::contextType)).setter(ContextSummary.setter(Builder::contextType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextType").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ContextSummary.getter(ContextSummary::creationTime)).setter(ContextSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ContextSummary.getter(ContextSummary::lastModifiedTime)).setter(ContextSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTEXT_ARN_FIELD, CONTEXT_NAME_FIELD, SOURCE_FIELD, CONTEXT_TYPE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String contextArn;
    private final String contextName;
    private final ContextSource source;
    private final String contextType;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private ContextSummary(BuilderImpl builder) {
        this.contextArn = builder.contextArn;
        this.contextName = builder.contextName;
        this.source = builder.source;
        this.contextType = builder.contextType;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String contextArn() {
        return this.contextArn;
    }

    public final String contextName() {
        return this.contextName;
    }

    public final ContextSource source() {
        return this.source;
    }

    public final String contextType() {
        return this.contextType;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contextArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextName());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextType());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextSummary)) {
            return false;
        }
        ContextSummary other = (ContextSummary)obj;
        return Objects.equals(this.contextArn(), other.contextArn()) && Objects.equals(this.contextName(), other.contextName()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.contextType(), other.contextType()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"ContextSummary").add("ContextArn", (Object)this.contextArn()).add("ContextName", (Object)this.contextName()).add("Source", (Object)this.source()).add("ContextType", (Object)this.contextType()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContextArn": {
                return Optional.ofNullable(clazz.cast(this.contextArn()));
            }
            case "ContextName": {
                return Optional.ofNullable(clazz.cast(this.contextName()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "ContextType": {
                return Optional.ofNullable(clazz.cast(this.contextType()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContextSummary, T> g) {
        return obj -> g.apply((ContextSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contextArn;
        private String contextName;
        private ContextSource source;
        private String contextType;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ContextSummary model) {
            this.contextArn(model.contextArn);
            this.contextName(model.contextName);
            this.source(model.source);
            this.contextType(model.contextType);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getContextArn() {
            return this.contextArn;
        }

        public final void setContextArn(String contextArn) {
            this.contextArn = contextArn;
        }

        @Override
        @Transient
        public final Builder contextArn(String contextArn) {
            this.contextArn = contextArn;
            return this;
        }

        public final String getContextName() {
            return this.contextName;
        }

        public final void setContextName(String contextName) {
            this.contextName = contextName;
        }

        @Override
        @Transient
        public final Builder contextName(String contextName) {
            this.contextName = contextName;
            return this;
        }

        public final ContextSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(ContextSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        @Transient
        public final Builder source(ContextSource source) {
            this.source = source;
            return this;
        }

        public final String getContextType() {
            return this.contextType;
        }

        public final void setContextType(String contextType) {
            this.contextType = contextType;
        }

        @Override
        @Transient
        public final Builder contextType(String contextType) {
            this.contextType = contextType;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public ContextSummary build() {
            return new ContextSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContextSummary> {
        public Builder contextArn(String var1);

        public Builder contextName(String var1);

        public Builder source(ContextSource var1);

        default public Builder source(Consumer<ContextSource.Builder> source) {
            return this.source((ContextSource)((ContextSource.Builder)ContextSource.builder().applyMutation(source)).build());
        }

        public Builder contextType(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

