/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.AppDetails;
import software.amazon.awssdk.services.sagemaker.model.ListAppsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAppsResponse;

public class ListAppsPublisher
implements SdkPublisher<ListAppsResponse> {
    private final SageMakerAsyncClient client;
    private final ListAppsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppsPublisher(SageMakerAsyncClient client, ListAppsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppsPublisher(SageMakerAsyncClient client, ListAppsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AppDetails> apps() {
        Function<ListAppsResponse, Iterator> getIterator = response -> {
            if (response != null && response.apps() != null) {
                return response.apps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAppsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAppsResponseFetcher
    implements AsyncPageFetcher<ListAppsResponse> {
        private ListAppsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppsResponse> nextPage(ListAppsResponse previousPage) {
            if (previousPage == null) {
                return ListAppsPublisher.this.client.listApps(ListAppsPublisher.this.firstRequest);
            }
            return ListAppsPublisher.this.client.listApps((ListAppsRequest)((Object)ListAppsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

