/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.AppImageConfigDetails;
import software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse;

public class ListAppImageConfigsPublisher
implements SdkPublisher<ListAppImageConfigsResponse> {
    private final SageMakerAsyncClient client;
    private final ListAppImageConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppImageConfigsPublisher(SageMakerAsyncClient client, ListAppImageConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppImageConfigsPublisher(SageMakerAsyncClient client, ListAppImageConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppImageConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppImageConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AppImageConfigDetails> appImageConfigs() {
        Function<ListAppImageConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.appImageConfigs() != null) {
                return response.appImageConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAppImageConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAppImageConfigsResponseFetcher
    implements AsyncPageFetcher<ListAppImageConfigsResponse> {
        private ListAppImageConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppImageConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppImageConfigsResponse> nextPage(ListAppImageConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListAppImageConfigsPublisher.this.client.listAppImageConfigs(ListAppImageConfigsPublisher.this.firstRequest);
            }
            return ListAppImageConfigsPublisher.this.client.listAppImageConfigs((ListAppImageConfigsRequest)((Object)ListAppImageConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

