/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelApprovalStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateModelPackageRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateModelPackageRequest> {
    private static final SdkField<String> MODEL_PACKAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageArn").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::modelPackageArn)).setter(UpdateModelPackageRequest.setter(Builder::modelPackageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageArn").build()}).build();
    private static final SdkField<String> MODEL_APPROVAL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelApprovalStatus").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::modelApprovalStatusAsString)).setter(UpdateModelPackageRequest.setter(Builder::modelApprovalStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelApprovalStatus").build()}).build();
    private static final SdkField<String> APPROVAL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApprovalDescription").getter(UpdateModelPackageRequest.getter(UpdateModelPackageRequest::approvalDescription)).setter(UpdateModelPackageRequest.setter(Builder::approvalDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_ARN_FIELD, MODEL_APPROVAL_STATUS_FIELD, APPROVAL_DESCRIPTION_FIELD));
    private final String modelPackageArn;
    private final String modelApprovalStatus;
    private final String approvalDescription;

    private UpdateModelPackageRequest(BuilderImpl builder) {
        super(builder);
        this.modelPackageArn = builder.modelPackageArn;
        this.modelApprovalStatus = builder.modelApprovalStatus;
        this.approvalDescription = builder.approvalDescription;
    }

    public final String modelPackageArn() {
        return this.modelPackageArn;
    }

    public final ModelApprovalStatus modelApprovalStatus() {
        return ModelApprovalStatus.fromValue(this.modelApprovalStatus);
    }

    public final String modelApprovalStatusAsString() {
        return this.modelApprovalStatus;
    }

    public final String approvalDescription() {
        return this.approvalDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelApprovalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateModelPackageRequest)) {
            return false;
        }
        UpdateModelPackageRequest other = (UpdateModelPackageRequest)((Object)obj);
        return Objects.equals(this.modelPackageArn(), other.modelPackageArn()) && Objects.equals(this.modelApprovalStatusAsString(), other.modelApprovalStatusAsString()) && Objects.equals(this.approvalDescription(), other.approvalDescription());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateModelPackageRequest").add("ModelPackageArn", (Object)this.modelPackageArn()).add("ModelApprovalStatus", (Object)this.modelApprovalStatusAsString()).add("ApprovalDescription", (Object)this.approvalDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelPackageArn": {
                return Optional.ofNullable(clazz.cast(this.modelPackageArn()));
            }
            case "ModelApprovalStatus": {
                return Optional.ofNullable(clazz.cast(this.modelApprovalStatusAsString()));
            }
            case "ApprovalDescription": {
                return Optional.ofNullable(clazz.cast(this.approvalDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateModelPackageRequest, T> g) {
        return obj -> g.apply((UpdateModelPackageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String modelPackageArn;
        private String modelApprovalStatus;
        private String approvalDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateModelPackageRequest model) {
            super(model);
            this.modelPackageArn(model.modelPackageArn);
            this.modelApprovalStatus(model.modelApprovalStatus);
            this.approvalDescription(model.approvalDescription);
        }

        public final String getModelPackageArn() {
            return this.modelPackageArn;
        }

        public final void setModelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
        }

        @Override
        @Transient
        public final Builder modelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
            return this;
        }

        public final String getModelApprovalStatus() {
            return this.modelApprovalStatus;
        }

        public final void setModelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
        }

        @Override
        @Transient
        public final Builder modelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus) {
            this.modelApprovalStatus(modelApprovalStatus == null ? null : modelApprovalStatus.toString());
            return this;
        }

        public final String getApprovalDescription() {
            return this.approvalDescription;
        }

        public final void setApprovalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
        }

        @Override
        @Transient
        public final Builder approvalDescription(String approvalDescription) {
            this.approvalDescription = approvalDescription;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateModelPackageRequest build() {
            return new UpdateModelPackageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateModelPackageRequest> {
        public Builder modelPackageArn(String var1);

        public Builder modelApprovalStatus(String var1);

        public Builder modelApprovalStatus(ModelApprovalStatus var1);

        public Builder approvalDescription(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

