/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobStatus;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceRecommendationsJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceRecommendationsJob> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(InferenceRecommendationsJob.getter(InferenceRecommendationsJob::jobName)).setter(InferenceRecommendationsJob.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> JOB_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobDescription").getter(InferenceRecommendationsJob.getter(InferenceRecommendationsJob::jobDescription)).setter(InferenceRecommendationsJob.setter(Builder::jobDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDescription").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(InferenceRecommendationsJob.getter(InferenceRecommendationsJob::jobTypeAsString)).setter(InferenceRecommendationsJob.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobArn").getter(InferenceRecommendationsJob.getter(InferenceRecommendationsJob::jobArn)).setter(InferenceRecommendationsJob.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(InferenceRecommendationsJob.getter(InferenceRecommendationsJob::statusAsString)).setter(InferenceRecommendationsJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(InferenceRecommendationsJob.getter(InferenceRecommendationsJob::creationTime)).setter(InferenceRecommendationsJob.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(InferenceRecommendationsJob.getter(InferenceRecommendationsJob::completionTime)).setter(InferenceRecommendationsJob.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(InferenceRecommendationsJob.getter(InferenceRecommendationsJob::roleArn)).setter(InferenceRecommendationsJob.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(InferenceRecommendationsJob.getter(InferenceRecommendationsJob::lastModifiedTime)).setter(InferenceRecommendationsJob.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(InferenceRecommendationsJob.getter(InferenceRecommendationsJob::failureReason)).setter(InferenceRecommendationsJob.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, JOB_DESCRIPTION_FIELD, JOB_TYPE_FIELD, JOB_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD, ROLE_ARN_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobName;
    private final String jobDescription;
    private final String jobType;
    private final String jobArn;
    private final String status;
    private final Instant creationTime;
    private final Instant completionTime;
    private final String roleArn;
    private final Instant lastModifiedTime;
    private final String failureReason;

    private InferenceRecommendationsJob(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobDescription = builder.jobDescription;
        this.jobType = builder.jobType;
        this.jobArn = builder.jobArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.roleArn = builder.roleArn;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String jobDescription() {
        return this.jobDescription;
    }

    public final RecommendationJobType jobType() {
        return RecommendationJobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final RecommendationJobStatus status() {
        return RecommendationJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceRecommendationsJob)) {
            return false;
        }
        InferenceRecommendationsJob other = (InferenceRecommendationsJob)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobDescription(), other.jobDescription()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceRecommendationsJob").add("JobName", (Object)this.jobName()).add("JobDescription", (Object)this.jobDescription()).add("JobType", (Object)this.jobTypeAsString()).add("JobArn", (Object)this.jobArn()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("CompletionTime", (Object)this.completionTime()).add("RoleArn", (Object)this.roleArn()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobDescription": {
                return Optional.ofNullable(clazz.cast(this.jobDescription()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "JobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceRecommendationsJob, T> g) {
        return obj -> g.apply((InferenceRecommendationsJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private String jobDescription;
        private String jobType;
        private String jobArn;
        private String status;
        private Instant creationTime;
        private Instant completionTime;
        private String roleArn;
        private Instant lastModifiedTime;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceRecommendationsJob model) {
            this.jobName(model.jobName);
            this.jobDescription(model.jobDescription);
            this.jobType(model.jobType);
            this.jobArn(model.jobArn);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.completionTime(model.completionTime);
            this.roleArn(model.roleArn);
            this.lastModifiedTime(model.lastModifiedTime);
            this.failureReason(model.failureReason);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobDescription() {
            return this.jobDescription;
        }

        public final void setJobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
        }

        @Override
        public final Builder jobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(RecommendationJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecommendationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public InferenceRecommendationsJob build() {
            return new InferenceRecommendationsJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceRecommendationsJob> {
        public Builder jobName(String var1);

        public Builder jobDescription(String var1);

        public Builder jobType(String var1);

        public Builder jobType(RecommendationJobType var1);

        public Builder jobArn(String var1);

        public Builder status(String var1);

        public Builder status(RecommendationJobStatus var1);

        public Builder creationTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder roleArn(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder failureReason(String var1);
    }
}

