/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeployedImage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeployedImage> {
    private static final SdkField<String> SPECIFIED_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpecifiedImage").getter(DeployedImage.getter(DeployedImage::specifiedImage)).setter(DeployedImage.setter(Builder::specifiedImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpecifiedImage").build()}).build();
    private static final SdkField<String> RESOLVED_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResolvedImage").getter(DeployedImage.getter(DeployedImage::resolvedImage)).setter(DeployedImage.setter(Builder::resolvedImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedImage").build()}).build();
    private static final SdkField<Instant> RESOLUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ResolutionTime").getter(DeployedImage.getter(DeployedImage::resolutionTime)).setter(DeployedImage.setter(Builder::resolutionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolutionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPECIFIED_IMAGE_FIELD, RESOLVED_IMAGE_FIELD, RESOLUTION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String specifiedImage;
    private final String resolvedImage;
    private final Instant resolutionTime;

    private DeployedImage(BuilderImpl builder) {
        this.specifiedImage = builder.specifiedImage;
        this.resolvedImage = builder.resolvedImage;
        this.resolutionTime = builder.resolutionTime;
    }

    public final String specifiedImage() {
        return this.specifiedImage;
    }

    public final String resolvedImage() {
        return this.resolvedImage;
    }

    public final Instant resolutionTime() {
        return this.resolutionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.specifiedImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeployedImage)) {
            return false;
        }
        DeployedImage other = (DeployedImage)obj;
        return Objects.equals(this.specifiedImage(), other.specifiedImage()) && Objects.equals(this.resolvedImage(), other.resolvedImage()) && Objects.equals(this.resolutionTime(), other.resolutionTime());
    }

    public final String toString() {
        return ToString.builder((String)"DeployedImage").add("SpecifiedImage", (Object)this.specifiedImage()).add("ResolvedImage", (Object)this.resolvedImage()).add("ResolutionTime", (Object)this.resolutionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpecifiedImage": {
                return Optional.ofNullable(clazz.cast(this.specifiedImage()));
            }
            case "ResolvedImage": {
                return Optional.ofNullable(clazz.cast(this.resolvedImage()));
            }
            case "ResolutionTime": {
                return Optional.ofNullable(clazz.cast(this.resolutionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeployedImage, T> g) {
        return obj -> g.apply((DeployedImage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String specifiedImage;
        private String resolvedImage;
        private Instant resolutionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DeployedImage model) {
            this.specifiedImage(model.specifiedImage);
            this.resolvedImage(model.resolvedImage);
            this.resolutionTime(model.resolutionTime);
        }

        public final String getSpecifiedImage() {
            return this.specifiedImage;
        }

        public final void setSpecifiedImage(String specifiedImage) {
            this.specifiedImage = specifiedImage;
        }

        @Override
        public final Builder specifiedImage(String specifiedImage) {
            this.specifiedImage = specifiedImage;
            return this;
        }

        public final String getResolvedImage() {
            return this.resolvedImage;
        }

        public final void setResolvedImage(String resolvedImage) {
            this.resolvedImage = resolvedImage;
        }

        @Override
        public final Builder resolvedImage(String resolvedImage) {
            this.resolvedImage = resolvedImage;
            return this;
        }

        public final Instant getResolutionTime() {
            return this.resolutionTime;
        }

        public final void setResolutionTime(Instant resolutionTime) {
            this.resolutionTime = resolutionTime;
        }

        @Override
        public final Builder resolutionTime(Instant resolutionTime) {
            this.resolutionTime = resolutionTime;
            return this;
        }

        public DeployedImage build() {
            return new DeployedImage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeployedImage> {
        public Builder specifiedImage(String var1);

        public Builder resolvedImage(String var1);

        public Builder resolutionTime(Instant var1);
    }
}

