/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ProcessingJobSummary;

public class ListProcessingJobsPublisher
implements SdkPublisher<ListProcessingJobsResponse> {
    private final SageMakerAsyncClient client;
    private final ListProcessingJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProcessingJobsPublisher(SageMakerAsyncClient client, ListProcessingJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProcessingJobsPublisher(SageMakerAsyncClient client, ListProcessingJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProcessingJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProcessingJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProcessingJobSummary> processingJobSummaries() {
        Function<ListProcessingJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.processingJobSummaries() != null) {
                return response.processingJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProcessingJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProcessingJobsResponseFetcher
    implements AsyncPageFetcher<ListProcessingJobsResponse> {
        private ListProcessingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListProcessingJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProcessingJobsResponse> nextPage(ListProcessingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListProcessingJobsPublisher.this.client.listProcessingJobs(ListProcessingJobsPublisher.this.firstRequest);
            }
            return ListProcessingJobsPublisher.this.client.listProcessingJobs((ListProcessingJobsRequest)((Object)ListProcessingJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

