/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinitionSummary;

public class ListModelQualityJobDefinitionsIterable
implements SdkIterable<ListModelQualityJobDefinitionsResponse> {
    private final SageMakerClient client;
    private final ListModelQualityJobDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelQualityJobDefinitionsIterable(SageMakerClient client, ListModelQualityJobDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListModelQualityJobDefinitionsResponseFetcher();
    }

    public Iterator<ListModelQualityJobDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MonitoringJobDefinitionSummary> jobDefinitionSummaries() {
        Function<ListModelQualityJobDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobDefinitionSummaries() != null) {
                return response.jobDefinitionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelQualityJobDefinitionsResponseFetcher
    implements SyncPageFetcher<ListModelQualityJobDefinitionsResponse> {
        private ListModelQualityJobDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelQualityJobDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelQualityJobDefinitionsResponse nextPage(ListModelQualityJobDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListModelQualityJobDefinitionsIterable.this.client.listModelQualityJobDefinitions(ListModelQualityJobDefinitionsIterable.this.firstRequest);
            }
            return ListModelQualityJobDefinitionsIterable.this.client.listModelQualityJobDefinitions((ListModelQualityJobDefinitionsRequest)((Object)ListModelQualityJobDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

