/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.UserSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUserProfileRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateUserProfileRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(CreateUserProfileRequest.getter(CreateUserProfileRequest::domainId)).setter(CreateUserProfileRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserProfileName").getter(CreateUserProfileRequest.getter(CreateUserProfileRequest::userProfileName)).setter(CreateUserProfileRequest.setter(Builder::userProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()}).build();
    private static final SdkField<String> SINGLE_SIGN_ON_USER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SingleSignOnUserIdentifier").getter(CreateUserProfileRequest.getter(CreateUserProfileRequest::singleSignOnUserIdentifier)).setter(CreateUserProfileRequest.setter(Builder::singleSignOnUserIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSignOnUserIdentifier").build()}).build();
    private static final SdkField<String> SINGLE_SIGN_ON_USER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SingleSignOnUserValue").getter(CreateUserProfileRequest.getter(CreateUserProfileRequest::singleSignOnUserValue)).setter(CreateUserProfileRequest.setter(Builder::singleSignOnUserValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSignOnUserValue").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateUserProfileRequest.getter(CreateUserProfileRequest::tags)).setter(CreateUserProfileRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<UserSettings> USER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserSettings").getter(CreateUserProfileRequest.getter(CreateUserProfileRequest::userSettings)).setter(CreateUserProfileRequest.setter(Builder::userSettings)).constructor(UserSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, USER_PROFILE_NAME_FIELD, SINGLE_SIGN_ON_USER_IDENTIFIER_FIELD, SINGLE_SIGN_ON_USER_VALUE_FIELD, TAGS_FIELD, USER_SETTINGS_FIELD));
    private final String domainId;
    private final String userProfileName;
    private final String singleSignOnUserIdentifier;
    private final String singleSignOnUserValue;
    private final List<Tag> tags;
    private final UserSettings userSettings;

    private CreateUserProfileRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.userProfileName = builder.userProfileName;
        this.singleSignOnUserIdentifier = builder.singleSignOnUserIdentifier;
        this.singleSignOnUserValue = builder.singleSignOnUserValue;
        this.tags = builder.tags;
        this.userSettings = builder.userSettings;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String userProfileName() {
        return this.userProfileName;
    }

    public final String singleSignOnUserIdentifier() {
        return this.singleSignOnUserIdentifier;
    }

    public final String singleSignOnUserValue() {
        return this.singleSignOnUserValue;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final UserSettings userSettings() {
        return this.userSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleSignOnUserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleSignOnUserValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserProfileRequest)) {
            return false;
        }
        CreateUserProfileRequest other = (CreateUserProfileRequest)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.userProfileName(), other.userProfileName()) && Objects.equals(this.singleSignOnUserIdentifier(), other.singleSignOnUserIdentifier()) && Objects.equals(this.singleSignOnUserValue(), other.singleSignOnUserValue()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.userSettings(), other.userSettings());
    }

    public final String toString() {
        return ToString.builder((String)"CreateUserProfileRequest").add("DomainId", (Object)this.domainId()).add("UserProfileName", (Object)this.userProfileName()).add("SingleSignOnUserIdentifier", (Object)this.singleSignOnUserIdentifier()).add("SingleSignOnUserValue", (Object)this.singleSignOnUserValue()).add("Tags", this.hasTags() ? this.tags() : null).add("UserSettings", (Object)this.userSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "UserProfileName": {
                return Optional.ofNullable(clazz.cast(this.userProfileName()));
            }
            case "SingleSignOnUserIdentifier": {
                return Optional.ofNullable(clazz.cast(this.singleSignOnUserIdentifier()));
            }
            case "SingleSignOnUserValue": {
                return Optional.ofNullable(clazz.cast(this.singleSignOnUserValue()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UserSettings": {
                return Optional.ofNullable(clazz.cast(this.userSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserProfileRequest, T> g) {
        return obj -> g.apply((CreateUserProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String domainId;
        private String userProfileName;
        private String singleSignOnUserIdentifier;
        private String singleSignOnUserValue;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private UserSettings userSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserProfileRequest model) {
            super(model);
            this.domainId(model.domainId);
            this.userProfileName(model.userProfileName);
            this.singleSignOnUserIdentifier(model.singleSignOnUserIdentifier);
            this.singleSignOnUserValue(model.singleSignOnUserValue);
            this.tags(model.tags);
            this.userSettings(model.userSettings);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public final String getUserProfileName() {
            return this.userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        public final String getSingleSignOnUserIdentifier() {
            return this.singleSignOnUserIdentifier;
        }

        @Override
        public final Builder singleSignOnUserIdentifier(String singleSignOnUserIdentifier) {
            this.singleSignOnUserIdentifier = singleSignOnUserIdentifier;
            return this;
        }

        public final void setSingleSignOnUserIdentifier(String singleSignOnUserIdentifier) {
            this.singleSignOnUserIdentifier = singleSignOnUserIdentifier;
        }

        public final String getSingleSignOnUserValue() {
            return this.singleSignOnUserValue;
        }

        @Override
        public final Builder singleSignOnUserValue(String singleSignOnUserValue) {
            this.singleSignOnUserValue = singleSignOnUserValue;
            return this;
        }

        public final void setSingleSignOnUserValue(String singleSignOnUserValue) {
            this.singleSignOnUserValue = singleSignOnUserValue;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final UserSettings.Builder getUserSettings() {
            return this.userSettings != null ? this.userSettings.toBuilder() : null;
        }

        @Override
        public final Builder userSettings(UserSettings userSettings) {
            this.userSettings = userSettings;
            return this;
        }

        public final void setUserSettings(UserSettings.BuilderImpl userSettings) {
            this.userSettings = userSettings != null ? userSettings.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserProfileRequest build() {
            return new CreateUserProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUserProfileRequest> {
        public Builder domainId(String var1);

        public Builder userProfileName(String var1);

        public Builder singleSignOnUserIdentifier(String var1);

        public Builder singleSignOnUserValue(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder userSettings(UserSettings var1);

        default public Builder userSettings(Consumer<UserSettings.Builder> userSettings) {
            return this.userSettings((UserSettings)((UserSettings.Builder)UserSettings.builder().applyMutation(userSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

