/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.EdgeOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeviceFleetResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeDeviceFleetResponse> {
    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceFleetName").getter(DescribeDeviceFleetResponse.getter(DescribeDeviceFleetResponse::deviceFleetName)).setter(DescribeDeviceFleetResponse.setter(Builder::deviceFleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()}).build();
    private static final SdkField<String> DEVICE_FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceFleetArn").getter(DescribeDeviceFleetResponse.getter(DescribeDeviceFleetResponse::deviceFleetArn)).setter(DescribeDeviceFleetResponse.setter(Builder::deviceFleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetArn").build()}).build();
    private static final SdkField<EdgeOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(DescribeDeviceFleetResponse.getter(DescribeDeviceFleetResponse::outputConfig)).setter(DescribeDeviceFleetResponse.setter(Builder::outputConfig)).constructor(EdgeOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeDeviceFleetResponse.getter(DescribeDeviceFleetResponse::description)).setter(DescribeDeviceFleetResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeDeviceFleetResponse.getter(DescribeDeviceFleetResponse::creationTime)).setter(DescribeDeviceFleetResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeDeviceFleetResponse.getter(DescribeDeviceFleetResponse::lastModifiedTime)).setter(DescribeDeviceFleetResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeDeviceFleetResponse.getter(DescribeDeviceFleetResponse::roleArn)).setter(DescribeDeviceFleetResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> IOT_ROLE_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IotRoleAlias").getter(DescribeDeviceFleetResponse.getter(DescribeDeviceFleetResponse::iotRoleAlias)).setter(DescribeDeviceFleetResponse.setter(Builder::iotRoleAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IotRoleAlias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FLEET_NAME_FIELD, DEVICE_FLEET_ARN_FIELD, OUTPUT_CONFIG_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, ROLE_ARN_FIELD, IOT_ROLE_ALIAS_FIELD));
    private final String deviceFleetName;
    private final String deviceFleetArn;
    private final EdgeOutputConfig outputConfig;
    private final String description;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String roleArn;
    private final String iotRoleAlias;

    private DescribeDeviceFleetResponse(BuilderImpl builder) {
        super(builder);
        this.deviceFleetName = builder.deviceFleetName;
        this.deviceFleetArn = builder.deviceFleetArn;
        this.outputConfig = builder.outputConfig;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.roleArn = builder.roleArn;
        this.iotRoleAlias = builder.iotRoleAlias;
    }

    public final String deviceFleetName() {
        return this.deviceFleetName;
    }

    public final String deviceFleetArn() {
        return this.deviceFleetArn;
    }

    public final EdgeOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final String description() {
        return this.description;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String iotRoleAlias() {
        return this.iotRoleAlias;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceFleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotRoleAlias());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceFleetResponse)) {
            return false;
        }
        DescribeDeviceFleetResponse other = (DescribeDeviceFleetResponse)((Object)obj);
        return Objects.equals(this.deviceFleetName(), other.deviceFleetName()) && Objects.equals(this.deviceFleetArn(), other.deviceFleetArn()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.iotRoleAlias(), other.iotRoleAlias());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDeviceFleetResponse").add("DeviceFleetName", (Object)this.deviceFleetName()).add("DeviceFleetArn", (Object)this.deviceFleetArn()).add("OutputConfig", (Object)this.outputConfig()).add("Description", (Object)this.description()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("RoleArn", (Object)this.roleArn()).add("IotRoleAlias", (Object)this.iotRoleAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceFleetName": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetName()));
            }
            case "DeviceFleetArn": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetArn()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "IotRoleAlias": {
                return Optional.ofNullable(clazz.cast(this.iotRoleAlias()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceFleetResponse, T> g) {
        return obj -> g.apply((DescribeDeviceFleetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String deviceFleetName;
        private String deviceFleetArn;
        private EdgeOutputConfig outputConfig;
        private String description;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String roleArn;
        private String iotRoleAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceFleetResponse model) {
            super(model);
            this.deviceFleetName(model.deviceFleetName);
            this.deviceFleetArn(model.deviceFleetArn);
            this.outputConfig(model.outputConfig);
            this.description(model.description);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.roleArn(model.roleArn);
            this.iotRoleAlias(model.iotRoleAlias);
        }

        public final String getDeviceFleetName() {
            return this.deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        public final String getDeviceFleetArn() {
            return this.deviceFleetArn;
        }

        @Override
        public final Builder deviceFleetArn(String deviceFleetArn) {
            this.deviceFleetArn = deviceFleetArn;
            return this;
        }

        public final void setDeviceFleetArn(String deviceFleetArn) {
            this.deviceFleetArn = deviceFleetArn;
        }

        public final EdgeOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(EdgeOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(EdgeOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getIotRoleAlias() {
            return this.iotRoleAlias;
        }

        @Override
        public final Builder iotRoleAlias(String iotRoleAlias) {
            this.iotRoleAlias = iotRoleAlias;
            return this;
        }

        public final void setIotRoleAlias(String iotRoleAlias) {
            this.iotRoleAlias = iotRoleAlias;
        }

        @Override
        public DescribeDeviceFleetResponse build() {
            return new DescribeDeviceFleetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeviceFleetResponse> {
        public Builder deviceFleetName(String var1);

        public Builder deviceFleetArn(String var1);

        public Builder outputConfig(EdgeOutputConfig var1);

        default public Builder outputConfig(Consumer<EdgeOutputConfig.Builder> outputConfig) {
            return this.outputConfig((EdgeOutputConfig)((EdgeOutputConfig.Builder)EdgeOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder description(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder roleArn(String var1);

        public Builder iotRoleAlias(String var1);
    }
}

