/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the ARN's of a SageMaker image and SageMaker image version, and the instance type that the version runs on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceSpec implements SdkPojo, Serializable, ToCopyableBuilder<ResourceSpec.Builder, ResourceSpec> {
    private static final SdkField<String> SAGE_MAKER_IMAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SageMakerImageArn").getter(getter(ResourceSpec::sageMakerImageArn))
            .setter(setter(Builder::sageMakerImageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerImageArn").build()).build();

    private static final SdkField<String> SAGE_MAKER_IMAGE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SageMakerImageVersionArn").getter(getter(ResourceSpec::sageMakerImageVersionArn))
            .setter(setter(Builder::sageMakerImageVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerImageVersionArn").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(ResourceSpec::instanceTypeAsString)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAGE_MAKER_IMAGE_ARN_FIELD,
            SAGE_MAKER_IMAGE_VERSION_ARN_FIELD, INSTANCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sageMakerImageArn;

    private final String sageMakerImageVersionArn;

    private final String instanceType;

    private ResourceSpec(BuilderImpl builder) {
        this.sageMakerImageArn = builder.sageMakerImageArn;
        this.sageMakerImageVersionArn = builder.sageMakerImageVersionArn;
        this.instanceType = builder.instanceType;
    }

    /**
     * <p>
     * The ARN of the SageMaker image that the image version belongs to.
     * </p>
     * 
     * @return The ARN of the SageMaker image that the image version belongs to.
     */
    public final String sageMakerImageArn() {
        return sageMakerImageArn;
    }

    /**
     * <p>
     * The ARN of the image version created on the instance.
     * </p>
     * 
     * @return The ARN of the image version created on the instance.
     */
    public final String sageMakerImageVersionArn() {
        return sageMakerImageVersionArn;
    }

    /**
     * <p>
     * The instance type that the image version runs on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link AppInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type that the image version runs on.
     * @see AppInstanceType
     */
    public final AppInstanceType instanceType() {
        return AppInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type that the image version runs on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link AppInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type that the image version runs on.
     * @see AppInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sageMakerImageArn());
        hashCode = 31 * hashCode + Objects.hashCode(sageMakerImageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSpec)) {
            return false;
        }
        ResourceSpec other = (ResourceSpec) obj;
        return Objects.equals(sageMakerImageArn(), other.sageMakerImageArn())
                && Objects.equals(sageMakerImageVersionArn(), other.sageMakerImageVersionArn())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceSpec").add("SageMakerImageArn", sageMakerImageArn())
                .add("SageMakerImageVersionArn", sageMakerImageVersionArn()).add("InstanceType", instanceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SageMakerImageArn":
            return Optional.ofNullable(clazz.cast(sageMakerImageArn()));
        case "SageMakerImageVersionArn":
            return Optional.ofNullable(clazz.cast(sageMakerImageVersionArn()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSpec, T> g) {
        return obj -> g.apply((ResourceSpec) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceSpec> {
        /**
         * <p>
         * The ARN of the SageMaker image that the image version belongs to.
         * </p>
         * 
         * @param sageMakerImageArn
         *        The ARN of the SageMaker image that the image version belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sageMakerImageArn(String sageMakerImageArn);

        /**
         * <p>
         * The ARN of the image version created on the instance.
         * </p>
         * 
         * @param sageMakerImageVersionArn
         *        The ARN of the image version created on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sageMakerImageVersionArn(String sageMakerImageVersionArn);

        /**
         * <p>
         * The instance type that the image version runs on.
         * </p>
         * 
         * @param instanceType
         *        The instance type that the image version runs on.
         * @see AppInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type that the image version runs on.
         * </p>
         * 
         * @param instanceType
         *        The instance type that the image version runs on.
         * @see AppInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppInstanceType
         */
        Builder instanceType(AppInstanceType instanceType);
    }

    static final class BuilderImpl implements Builder {
        private String sageMakerImageArn;

        private String sageMakerImageVersionArn;

        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSpec model) {
            sageMakerImageArn(model.sageMakerImageArn);
            sageMakerImageVersionArn(model.sageMakerImageVersionArn);
            instanceType(model.instanceType);
        }

        public final String getSageMakerImageArn() {
            return sageMakerImageArn;
        }

        @Override
        public final Builder sageMakerImageArn(String sageMakerImageArn) {
            this.sageMakerImageArn = sageMakerImageArn;
            return this;
        }

        public final void setSageMakerImageArn(String sageMakerImageArn) {
            this.sageMakerImageArn = sageMakerImageArn;
        }

        public final String getSageMakerImageVersionArn() {
            return sageMakerImageVersionArn;
        }

        @Override
        public final Builder sageMakerImageVersionArn(String sageMakerImageVersionArn) {
            this.sageMakerImageVersionArn = sageMakerImageVersionArn;
            return this;
        }

        public final void setSageMakerImageVersionArn(String sageMakerImageVersionArn) {
            this.sageMakerImageVersionArn = sageMakerImageVersionArn;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(AppInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public ResourceSpec build() {
            return new ResourceSpec(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
