/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains explainability metrics for a model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Explainability implements SdkPojo, Serializable, ToCopyableBuilder<Explainability.Builder, Explainability> {
    private static final SdkField<MetricsSource> REPORT_FIELD = SdkField.<MetricsSource> builder(MarshallingType.SDK_POJO)
            .memberName("Report").getter(getter(Explainability::report)).setter(setter(Builder::report))
            .constructor(MetricsSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Report").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final MetricsSource report;

    private Explainability(BuilderImpl builder) {
        this.report = builder.report;
    }

    /**
     * <p>
     * The explainability report for a model.
     * </p>
     * 
     * @return The explainability report for a model.
     */
    public final MetricsSource report() {
        return report;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(report());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Explainability)) {
            return false;
        }
        Explainability other = (Explainability) obj;
        return Objects.equals(report(), other.report());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Explainability").add("Report", report()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Report":
            return Optional.ofNullable(clazz.cast(report()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Explainability, T> g) {
        return obj -> g.apply((Explainability) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Explainability> {
        /**
         * <p>
         * The explainability report for a model.
         * </p>
         * 
         * @param report
         *        The explainability report for a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder report(MetricsSource report);

        /**
         * <p>
         * The explainability report for a model.
         * </p>
         * This is a convenience that creates an instance of the {@link MetricsSource.Builder} avoiding the need to
         * create one manually via {@link MetricsSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricsSource.Builder#build()} is called immediately and its
         * result is passed to {@link #report(MetricsSource)}.
         * 
         * @param report
         *        a consumer that will call methods on {@link MetricsSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #report(MetricsSource)
         */
        default Builder report(Consumer<MetricsSource.Builder> report) {
            return report(MetricsSource.builder().applyMutation(report).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MetricsSource report;

        private BuilderImpl() {
        }

        private BuilderImpl(Explainability model) {
            report(model.report);
        }

        public final MetricsSource.Builder getReport() {
            return report != null ? report.toBuilder() : null;
        }

        @Override
        public final Builder report(MetricsSource report) {
            this.report = report;
            return this;
        }

        public final void setReport(MetricsSource.BuilderImpl report) {
            this.report = report != null ? report.build() : null;
        }

        @Override
        public Explainability build() {
            return new Explainability(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
