/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The meta data of the Glue table which serves as data catalog for the <code>OfflineStore</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataCatalogConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DataCatalogConfig.Builder, DataCatalogConfig> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(DataCatalogConfig::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(DataCatalogConfig::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(DataCatalogConfig::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            CATALOG_FIELD, DATABASE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tableName;

    private final String catalog;

    private final String database;

    private DataCatalogConfig(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.catalog = builder.catalog;
        this.database = builder.database;
    }

    /**
     * <p>
     * The name of the Glue table.
     * </p>
     * 
     * @return The name of the Glue table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The name of the Glue table catalog.
     * </p>
     * 
     * @return The name of the Glue table catalog.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The name of the Glue table database.
     * </p>
     * 
     * @return The name of the Glue table database.
     */
    public final String database() {
        return database;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCatalogConfig)) {
            return false;
        }
        DataCatalogConfig other = (DataCatalogConfig) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(catalog(), other.catalog())
                && Objects.equals(database(), other.database());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataCatalogConfig").add("TableName", tableName()).add("Catalog", catalog())
                .add("Database", database()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataCatalogConfig, T> g) {
        return obj -> g.apply((DataCatalogConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataCatalogConfig> {
        /**
         * <p>
         * The name of the Glue table.
         * </p>
         * 
         * @param tableName
         *        The name of the Glue table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The name of the Glue table catalog.
         * </p>
         * 
         * @param catalog
         *        The name of the Glue table catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The name of the Glue table database.
         * </p>
         * 
         * @param database
         *        The name of the Glue table database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);
    }

    static final class BuilderImpl implements Builder {
        private String tableName;

        private String catalog;

        private String database;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCatalogConfig model) {
            tableName(model.tableName);
            catalog(model.catalog);
            database(model.database);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getCatalog() {
            return catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        public final String getDatabase() {
            return database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public DataCatalogConfig build() {
            return new DataCatalogConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
