/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHumanTaskUiRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateHumanTaskUiRequest.Builder, CreateHumanTaskUiRequest> {
    private static final SdkField<String> HUMAN_TASK_UI_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HumanTaskUiName").getter(getter(CreateHumanTaskUiRequest::humanTaskUiName))
            .setter(setter(Builder::humanTaskUiName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiName").build()).build();

    private static final SdkField<UiTemplate> UI_TEMPLATE_FIELD = SdkField.<UiTemplate> builder(MarshallingType.SDK_POJO)
            .memberName("UiTemplate").getter(getter(CreateHumanTaskUiRequest::uiTemplate)).setter(setter(Builder::uiTemplate))
            .constructor(UiTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UiTemplate").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateHumanTaskUiRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_TASK_UI_NAME_FIELD,
            UI_TEMPLATE_FIELD, TAGS_FIELD));

    private final String humanTaskUiName;

    private final UiTemplate uiTemplate;

    private final List<Tag> tags;

    private CreateHumanTaskUiRequest(BuilderImpl builder) {
        super(builder);
        this.humanTaskUiName = builder.humanTaskUiName;
        this.uiTemplate = builder.uiTemplate;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the user interface you are creating.
     * </p>
     * 
     * @return The name of the user interface you are creating.
     */
    public final String humanTaskUiName() {
        return humanTaskUiName;
    }

    /**
     * Returns the value of the UiTemplate property for this object.
     * 
     * @return The value of the UiTemplate property for this object.
     */
    public final UiTemplate uiTemplate() {
        return uiTemplate;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs that contain metadata to help you categorize and organize a human review workflow
     * user interface. Each tag consists of a key and a value, both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of key-value pairs that contain metadata to help you categorize and organize a human review
     *         workflow user interface. Each tag consists of a key and a value, both of which you define.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(humanTaskUiName());
        hashCode = 31 * hashCode + Objects.hashCode(uiTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHumanTaskUiRequest)) {
            return false;
        }
        CreateHumanTaskUiRequest other = (CreateHumanTaskUiRequest) obj;
        return Objects.equals(humanTaskUiName(), other.humanTaskUiName()) && Objects.equals(uiTemplate(), other.uiTemplate())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHumanTaskUiRequest").add("HumanTaskUiName", humanTaskUiName())
                .add("UiTemplate", uiTemplate()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanTaskUiName":
            return Optional.ofNullable(clazz.cast(humanTaskUiName()));
        case "UiTemplate":
            return Optional.ofNullable(clazz.cast(uiTemplate()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHumanTaskUiRequest, T> g) {
        return obj -> g.apply((CreateHumanTaskUiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateHumanTaskUiRequest> {
        /**
         * <p>
         * The name of the user interface you are creating.
         * </p>
         * 
         * @param humanTaskUiName
         *        The name of the user interface you are creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanTaskUiName(String humanTaskUiName);

        /**
         * Sets the value of the UiTemplate property for this object.
         *
         * @param uiTemplate
         *        The new value for the UiTemplate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uiTemplate(UiTemplate uiTemplate);

        /**
         * Sets the value of the UiTemplate property for this object.
         *
         * This is a convenience that creates an instance of the {@link UiTemplate.Builder} avoiding the need to create
         * one manually via {@link UiTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link UiTemplate.Builder#build()} is called immediately and its result
         * is passed to {@link #uiTemplate(UiTemplate)}.
         * 
         * @param uiTemplate
         *        a consumer that will call methods on {@link UiTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uiTemplate(UiTemplate)
         */
        default Builder uiTemplate(Consumer<UiTemplate.Builder> uiTemplate) {
            return uiTemplate(UiTemplate.builder().applyMutation(uiTemplate).build());
        }

        /**
         * <p>
         * An array of key-value pairs that contain metadata to help you categorize and organize a human review workflow
         * user interface. Each tag consists of a key and a value, both of which you define.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs that contain metadata to help you categorize and organize a human review
         *        workflow user interface. Each tag consists of a key and a value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs that contain metadata to help you categorize and organize a human review workflow
         * user interface. Each tag consists of a key and a value, both of which you define.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs that contain metadata to help you categorize and organize a human review
         *        workflow user interface. Each tag consists of a key and a value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs that contain metadata to help you categorize and organize a human review workflow
         * user interface. Each tag consists of a key and a value, both of which you define.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String humanTaskUiName;

        private UiTemplate uiTemplate;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHumanTaskUiRequest model) {
            super(model);
            humanTaskUiName(model.humanTaskUiName);
            uiTemplate(model.uiTemplate);
            tags(model.tags);
        }

        public final String getHumanTaskUiName() {
            return humanTaskUiName;
        }

        @Override
        public final Builder humanTaskUiName(String humanTaskUiName) {
            this.humanTaskUiName = humanTaskUiName;
            return this;
        }

        public final void setHumanTaskUiName(String humanTaskUiName) {
            this.humanTaskUiName = humanTaskUiName;
        }

        public final UiTemplate.Builder getUiTemplate() {
            return uiTemplate != null ? uiTemplate.toBuilder() : null;
        }

        @Override
        public final Builder uiTemplate(UiTemplate uiTemplate) {
            this.uiTemplate = uiTemplate;
            return this;
        }

        public final void setUiTemplate(UiTemplate.BuilderImpl uiTemplate) {
            this.uiTemplate = uiTemplate != null ? uiTemplate.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHumanTaskUiRequest build() {
            return new CreateHumanTaskUiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
