/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Security options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLSecurityConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoMLSecurityConfig.Builder, AutoMLSecurityConfig> {
    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeKmsKeyId").getter(getter(AutoMLSecurityConfig::volumeKmsKeyId))
            .setter(setter(Builder::volumeKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()).build();

    private static final SdkField<Boolean> ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableInterContainerTrafficEncryption")
            .getter(getter(AutoMLSecurityConfig::enableInterContainerTrafficEncryption))
            .setter(setter(Builder::enableInterContainerTrafficEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnableInterContainerTrafficEncryption").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(AutoMLSecurityConfig::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_KMS_KEY_ID_FIELD,
            ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD, VPC_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String volumeKmsKeyId;

    private final Boolean enableInterContainerTrafficEncryption;

    private final VpcConfig vpcConfig;

    private AutoMLSecurityConfig(BuilderImpl builder) {
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
        this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
        this.vpcConfig = builder.vpcConfig;
    }

    /**
     * <p>
     * The key used to encrypt stored data.
     * </p>
     * 
     * @return The key used to encrypt stored data.
     */
    public final String volumeKmsKeyId() {
        return volumeKmsKeyId;
    }

    /**
     * <p>
     * Whether to use traffic encryption between the container layers.
     * </p>
     * 
     * @return Whether to use traffic encryption between the container layers.
     */
    public final Boolean enableInterContainerTrafficEncryption() {
        return enableInterContainerTrafficEncryption;
    }

    /**
     * <p>
     * VPC configuration.
     * </p>
     * 
     * @return VPC configuration.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(enableInterContainerTrafficEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLSecurityConfig)) {
            return false;
        }
        AutoMLSecurityConfig other = (AutoMLSecurityConfig) obj;
        return Objects.equals(volumeKmsKeyId(), other.volumeKmsKeyId())
                && Objects.equals(enableInterContainerTrafficEncryption(), other.enableInterContainerTrafficEncryption())
                && Objects.equals(vpcConfig(), other.vpcConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoMLSecurityConfig").add("VolumeKmsKeyId", volumeKmsKeyId())
                .add("EnableInterContainerTrafficEncryption", enableInterContainerTrafficEncryption())
                .add("VpcConfig", vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeKmsKeyId":
            return Optional.ofNullable(clazz.cast(volumeKmsKeyId()));
        case "EnableInterContainerTrafficEncryption":
            return Optional.ofNullable(clazz.cast(enableInterContainerTrafficEncryption()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLSecurityConfig, T> g) {
        return obj -> g.apply((AutoMLSecurityConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLSecurityConfig> {
        /**
         * <p>
         * The key used to encrypt stored data.
         * </p>
         * 
         * @param volumeKmsKeyId
         *        The key used to encrypt stored data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeKmsKeyId(String volumeKmsKeyId);

        /**
         * <p>
         * Whether to use traffic encryption between the container layers.
         * </p>
         * 
         * @param enableInterContainerTrafficEncryption
         *        Whether to use traffic encryption between the container layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption);

        /**
         * <p>
         * VPC configuration.
         * </p>
         * 
         * @param vpcConfig
         *        VPC configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * VPC configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfig.Builder} avoiding the need to create
         * one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String volumeKmsKeyId;

        private Boolean enableInterContainerTrafficEncryption;

        private VpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLSecurityConfig model) {
            volumeKmsKeyId(model.volumeKmsKeyId);
            enableInterContainerTrafficEncryption(model.enableInterContainerTrafficEncryption);
            vpcConfig(model.vpcConfig);
        }

        public final String getVolumeKmsKeyId() {
            return volumeKmsKeyId;
        }

        @Override
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        public final Boolean getEnableInterContainerTrafficEncryption() {
            return enableInterContainerTrafficEncryption;
        }

        @Override
        public final Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
            return this;
        }

        public final void setEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public AutoMLSecurityConfig build() {
            return new AutoMLSecurityConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
