/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Lists a summary of the properties of an association. An association is an entity that links other lineage or
 * experiment entities. An example would be an association between a training job and a model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociationSummary.Builder, AssociationSummary> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceArn").getter(getter(AssociationSummary::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationArn").getter(getter(AssociationSummary::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationArn").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(AssociationSummary::sourceType)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationType").getter(getter(AssociationSummary::destinationType))
            .setter(setter(Builder::destinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationType").build()).build();

    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationType").getter(getter(AssociationSummary::associationTypeAsString))
            .setter(setter(Builder::associationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationType").build()).build();

    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceName").getter(getter(AssociationSummary::sourceName)).setter(setter(Builder::sourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceName").build()).build();

    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationName").getter(getter(AssociationSummary::destinationName))
            .setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(AssociationSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(AssociationSummary::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD,
            DESTINATION_ARN_FIELD, SOURCE_TYPE_FIELD, DESTINATION_TYPE_FIELD, ASSOCIATION_TYPE_FIELD, SOURCE_NAME_FIELD,
            DESTINATION_NAME_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceArn;

    private final String destinationArn;

    private final String sourceType;

    private final String destinationType;

    private final String associationType;

    private final String sourceName;

    private final String destinationName;

    private final Instant creationTime;

    private final UserContext createdBy;

    private AssociationSummary(BuilderImpl builder) {
        this.sourceArn = builder.sourceArn;
        this.destinationArn = builder.destinationArn;
        this.sourceType = builder.sourceType;
        this.destinationType = builder.destinationType;
        this.associationType = builder.associationType;
        this.sourceName = builder.sourceName;
        this.destinationName = builder.destinationName;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
    }

    /**
     * <p>
     * The ARN of the source.
     * </p>
     * 
     * @return The ARN of the source.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the destination.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the destination.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * The source type.
     * </p>
     * 
     * @return The source type.
     */
    public final String sourceType() {
        return sourceType;
    }

    /**
     * <p>
     * The destination type.
     * </p>
     * 
     * @return The destination type.
     */
    public final String destinationType() {
        return destinationType;
    }

    /**
     * <p>
     * The type of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AssociationEdgeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The type of the association.
     * @see AssociationEdgeType
     */
    public final AssociationEdgeType associationType() {
        return AssociationEdgeType.fromValue(associationType);
    }

    /**
     * <p>
     * The type of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationType}
     * will return {@link AssociationEdgeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #associationTypeAsString}.
     * </p>
     * 
     * @return The type of the association.
     * @see AssociationEdgeType
     */
    public final String associationTypeAsString() {
        return associationType;
    }

    /**
     * <p>
     * The name of the source.
     * </p>
     * 
     * @return The name of the source.
     */
    public final String sourceName() {
        return sourceName;
    }

    /**
     * <p>
     * The name of the destination.
     * </p>
     * 
     * @return The name of the destination.
     */
    public final String destinationName() {
        return destinationName;
    }

    /**
     * <p>
     * When the association was created.
     * </p>
     * 
     * @return When the association was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(destinationType());
        hashCode = 31 * hashCode + Objects.hashCode(associationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationSummary)) {
            return false;
        }
        AssociationSummary other = (AssociationSummary) obj;
        return Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(destinationArn(), other.destinationArn())
                && Objects.equals(sourceType(), other.sourceType()) && Objects.equals(destinationType(), other.destinationType())
                && Objects.equals(associationTypeAsString(), other.associationTypeAsString())
                && Objects.equals(sourceName(), other.sourceName()) && Objects.equals(destinationName(), other.destinationName())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(createdBy(), other.createdBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociationSummary").add("SourceArn", sourceArn()).add("DestinationArn", destinationArn())
                .add("SourceType", sourceType()).add("DestinationType", destinationType())
                .add("AssociationType", associationTypeAsString()).add("SourceName", sourceName())
                .add("DestinationName", destinationName()).add("CreationTime", creationTime()).add("CreatedBy", createdBy())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "DestinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "DestinationType":
            return Optional.ofNullable(clazz.cast(destinationType()));
        case "AssociationType":
            return Optional.ofNullable(clazz.cast(associationTypeAsString()));
        case "SourceName":
            return Optional.ofNullable(clazz.cast(sourceName()));
        case "DestinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociationSummary, T> g) {
        return obj -> g.apply((AssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociationSummary> {
        /**
         * <p>
         * The ARN of the source.
         * </p>
         * 
         * @param sourceArn
         *        The ARN of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the destination.
         * </p>
         * 
         * @param destinationArn
         *        The Amazon Resource Name (ARN) of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * The source type.
         * </p>
         * 
         * @param sourceType
         *        The source type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The destination type.
         * </p>
         * 
         * @param destinationType
         *        The destination type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationType(String destinationType);

        /**
         * <p>
         * The type of the association.
         * </p>
         * 
         * @param associationType
         *        The type of the association.
         * @see AssociationEdgeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationEdgeType
         */
        Builder associationType(String associationType);

        /**
         * <p>
         * The type of the association.
         * </p>
         * 
         * @param associationType
         *        The type of the association.
         * @see AssociationEdgeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationEdgeType
         */
        Builder associationType(AssociationEdgeType associationType);

        /**
         * <p>
         * The name of the source.
         * </p>
         * 
         * @param sourceName
         *        The name of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceName(String sourceName);

        /**
         * <p>
         * The name of the destination.
         * </p>
         * 
         * @param destinationName
         *        The name of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * When the association was created.
         * </p>
         * 
         * @param creationTime
         *        When the association was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sourceArn;

        private String destinationArn;

        private String sourceType;

        private String destinationType;

        private String associationType;

        private String sourceName;

        private String destinationName;

        private Instant creationTime;

        private UserContext createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationSummary model) {
            sourceArn(model.sourceArn);
            destinationArn(model.destinationArn);
            sourceType(model.sourceType);
            destinationType(model.destinationType);
            associationType(model.associationType);
            sourceName(model.sourceName);
            destinationName(model.destinationName);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        public final String getSourceType() {
            return sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getDestinationType() {
            return destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        public final String getAssociationType() {
            return associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(AssociationEdgeType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        public final String getSourceName() {
            return sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        public final String getDestinationName() {
            return destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public AssociationSummary build() {
            return new AssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
