/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.MetadataProperties;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentArtifact;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentArtifactsCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentParameterValue;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrialComponentRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateTrialComponentRequest> {
    private static final SdkField<String> TRIAL_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrialComponentName").getter(CreateTrialComponentRequest.getter(CreateTrialComponentRequest::trialComponentName)).setter(CreateTrialComponentRequest.setter(Builder::trialComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(CreateTrialComponentRequest.getter(CreateTrialComponentRequest::displayName)).setter(CreateTrialComponentRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<TrialComponentStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(CreateTrialComponentRequest.getter(CreateTrialComponentRequest::status)).setter(CreateTrialComponentRequest.setter(Builder::status)).constructor(TrialComponentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(CreateTrialComponentRequest.getter(CreateTrialComponentRequest::startTime)).setter(CreateTrialComponentRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(CreateTrialComponentRequest.getter(CreateTrialComponentRequest::endTime)).setter(CreateTrialComponentRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Map<String, TrialComponentParameterValue>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(CreateTrialComponentRequest.getter(CreateTrialComponentRequest::parameters)).setter(CreateTrialComponentRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, TrialComponentArtifact>> INPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("InputArtifacts").getter(CreateTrialComponentRequest.getter(CreateTrialComponentRequest::inputArtifacts)).setter(CreateTrialComponentRequest.setter(Builder::inputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputArtifacts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, TrialComponentArtifact>> OUTPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OutputArtifacts").getter(CreateTrialComponentRequest.getter(CreateTrialComponentRequest::outputArtifacts)).setter(CreateTrialComponentRequest.setter(Builder::outputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputArtifacts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<MetadataProperties> METADATA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataProperties").getter(CreateTrialComponentRequest.getter(CreateTrialComponentRequest::metadataProperties)).setter(CreateTrialComponentRequest.setter(Builder::metadataProperties)).constructor(MetadataProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProperties").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateTrialComponentRequest.getter(CreateTrialComponentRequest::tags)).setter(CreateTrialComponentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_COMPONENT_NAME_FIELD, DISPLAY_NAME_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, PARAMETERS_FIELD, INPUT_ARTIFACTS_FIELD, OUTPUT_ARTIFACTS_FIELD, METADATA_PROPERTIES_FIELD, TAGS_FIELD));
    private final String trialComponentName;
    private final String displayName;
    private final TrialComponentStatus status;
    private final Instant startTime;
    private final Instant endTime;
    private final Map<String, TrialComponentParameterValue> parameters;
    private final Map<String, TrialComponentArtifact> inputArtifacts;
    private final Map<String, TrialComponentArtifact> outputArtifacts;
    private final MetadataProperties metadataProperties;
    private final List<Tag> tags;

    private CreateTrialComponentRequest(BuilderImpl builder) {
        super(builder);
        this.trialComponentName = builder.trialComponentName;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.parameters = builder.parameters;
        this.inputArtifacts = builder.inputArtifacts;
        this.outputArtifacts = builder.outputArtifacts;
        this.metadataProperties = builder.metadataProperties;
        this.tags = builder.tags;
    }

    public final String trialComponentName() {
        return this.trialComponentName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final TrialComponentStatus status() {
        return this.status;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, TrialComponentParameterValue> parameters() {
        return this.parameters;
    }

    public final boolean hasInputArtifacts() {
        return this.inputArtifacts != null && !(this.inputArtifacts instanceof SdkAutoConstructMap);
    }

    public final Map<String, TrialComponentArtifact> inputArtifacts() {
        return this.inputArtifacts;
    }

    public final boolean hasOutputArtifacts() {
        return this.outputArtifacts != null && !(this.outputArtifacts instanceof SdkAutoConstructMap);
    }

    public final Map<String, TrialComponentArtifact> outputArtifacts() {
        return this.outputArtifacts;
    }

    public final MetadataProperties metadataProperties() {
        return this.metadataProperties;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputArtifacts() ? this.inputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputArtifacts() ? this.outputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrialComponentRequest)) {
            return false;
        }
        CreateTrialComponentRequest other = (CreateTrialComponentRequest)((Object)obj);
        return Objects.equals(this.trialComponentName(), other.trialComponentName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && this.hasInputArtifacts() == other.hasInputArtifacts() && Objects.equals(this.inputArtifacts(), other.inputArtifacts()) && this.hasOutputArtifacts() == other.hasOutputArtifacts() && Objects.equals(this.outputArtifacts(), other.outputArtifacts()) && Objects.equals(this.metadataProperties(), other.metadataProperties()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrialComponentRequest").add("TrialComponentName", (Object)this.trialComponentName()).add("DisplayName", (Object)this.displayName()).add("Status", (Object)this.status()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("InputArtifacts", this.hasInputArtifacts() ? this.inputArtifacts() : null).add("OutputArtifacts", this.hasOutputArtifacts() ? this.outputArtifacts() : null).add("MetadataProperties", (Object)this.metadataProperties()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrialComponentName": {
                return Optional.ofNullable(clazz.cast(this.trialComponentName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "InputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.inputArtifacts()));
            }
            case "OutputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.outputArtifacts()));
            }
            case "MetadataProperties": {
                return Optional.ofNullable(clazz.cast(this.metadataProperties()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrialComponentRequest, T> g) {
        return obj -> g.apply((CreateTrialComponentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String trialComponentName;
        private String displayName;
        private TrialComponentStatus status;
        private Instant startTime;
        private Instant endTime;
        private Map<String, TrialComponentParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, TrialComponentArtifact> inputArtifacts = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, TrialComponentArtifact> outputArtifacts = DefaultSdkAutoConstructMap.getInstance();
        private MetadataProperties metadataProperties;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrialComponentRequest model) {
            super(model);
            this.trialComponentName(model.trialComponentName);
            this.displayName(model.displayName);
            this.status(model.status);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.parameters(model.parameters);
            this.inputArtifacts(model.inputArtifacts);
            this.outputArtifacts(model.outputArtifacts);
            this.metadataProperties(model.metadataProperties);
            this.tags(model.tags);
        }

        public final String getTrialComponentName() {
            return this.trialComponentName;
        }

        @Override
        public final Builder trialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
            return this;
        }

        public final void setTrialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final TrialComponentStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(TrialComponentStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(TrialComponentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Map<String, TrialComponentParameterValue.Builder> getParameters() {
            Map<String, TrialComponentParameterValue.Builder> result = TrialComponentParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder parameters(Map<String, TrialComponentParameterValue> parameters) {
            this.parameters = TrialComponentParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, TrialComponentParameterValue.BuilderImpl> parameters) {
            this.parameters = TrialComponentParametersCopier.copyFromBuilder(parameters);
        }

        public final Map<String, TrialComponentArtifact.Builder> getInputArtifacts() {
            Map<String, TrialComponentArtifact.Builder> result = TrialComponentArtifactsCopier.copyToBuilder(this.inputArtifacts);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder inputArtifacts(Map<String, TrialComponentArtifact> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copy(inputArtifacts);
            return this;
        }

        public final void setInputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(inputArtifacts);
        }

        public final Map<String, TrialComponentArtifact.Builder> getOutputArtifacts() {
            Map<String, TrialComponentArtifact.Builder> result = TrialComponentArtifactsCopier.copyToBuilder(this.outputArtifacts);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder outputArtifacts(Map<String, TrialComponentArtifact> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copy(outputArtifacts);
            return this;
        }

        public final void setOutputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(outputArtifacts);
        }

        public final MetadataProperties.Builder getMetadataProperties() {
            return this.metadataProperties != null ? this.metadataProperties.toBuilder() : null;
        }

        @Override
        public final Builder metadataProperties(MetadataProperties metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        public final void setMetadataProperties(MetadataProperties.BuilderImpl metadataProperties) {
            this.metadataProperties = metadataProperties != null ? metadataProperties.build() : null;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrialComponentRequest build() {
            return new CreateTrialComponentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrialComponentRequest> {
        public Builder trialComponentName(String var1);

        public Builder displayName(String var1);

        public Builder status(TrialComponentStatus var1);

        default public Builder status(Consumer<TrialComponentStatus.Builder> status) {
            return this.status((TrialComponentStatus)((TrialComponentStatus.Builder)TrialComponentStatus.builder().applyMutation(status)).build());
        }

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder parameters(Map<String, TrialComponentParameterValue> var1);

        public Builder inputArtifacts(Map<String, TrialComponentArtifact> var1);

        public Builder outputArtifacts(Map<String, TrialComponentArtifact> var1);

        public Builder metadataProperties(MetadataProperties var1);

        default public Builder metadataProperties(Consumer<MetadataProperties.Builder> metadataProperties) {
            return this.metadataProperties((MetadataProperties)((MetadataProperties.Builder)MetadataProperties.builder().applyMutation(metadataProperties)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

