/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ArtifactSourceType;
import software.amazon.awssdk.services.sagemaker.model.ArtifactSourceTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArtifactSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArtifactSource> {
    private static final SdkField<String> SOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceUri").getter(ArtifactSource.getter(ArtifactSource::sourceUri)).setter(ArtifactSource.setter(Builder::sourceUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUri").build()}).build();
    private static final SdkField<List<ArtifactSourceType>> SOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceTypes").getter(ArtifactSource.getter(ArtifactSource::sourceTypes)).setter(ArtifactSource.setter(Builder::sourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArtifactSourceType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_URI_FIELD, SOURCE_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceUri;
    private final List<ArtifactSourceType> sourceTypes;

    private ArtifactSource(BuilderImpl builder) {
        this.sourceUri = builder.sourceUri;
        this.sourceTypes = builder.sourceTypes;
    }

    public final String sourceUri() {
        return this.sourceUri;
    }

    public final boolean hasSourceTypes() {
        return this.sourceTypes != null && !(this.sourceTypes instanceof SdkAutoConstructList);
    }

    public final List<ArtifactSourceType> sourceTypes() {
        return this.sourceTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceTypes() ? this.sourceTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactSource)) {
            return false;
        }
        ArtifactSource other = (ArtifactSource)obj;
        return Objects.equals(this.sourceUri(), other.sourceUri()) && this.hasSourceTypes() == other.hasSourceTypes() && Objects.equals(this.sourceTypes(), other.sourceTypes());
    }

    public final String toString() {
        return ToString.builder((String)"ArtifactSource").add("SourceUri", (Object)this.sourceUri()).add("SourceTypes", this.hasSourceTypes() ? this.sourceTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceUri": {
                return Optional.ofNullable(clazz.cast(this.sourceUri()));
            }
            case "SourceTypes": {
                return Optional.ofNullable(clazz.cast(this.sourceTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArtifactSource, T> g) {
        return obj -> g.apply((ArtifactSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceUri;
        private List<ArtifactSourceType> sourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactSource model) {
            this.sourceUri(model.sourceUri);
            this.sourceTypes(model.sourceTypes);
        }

        public final String getSourceUri() {
            return this.sourceUri;
        }

        @Override
        public final Builder sourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
            return this;
        }

        public final void setSourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
        }

        public final Collection<ArtifactSourceType.Builder> getSourceTypes() {
            if (this.sourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceTypes != null ? (Collection)this.sourceTypes.stream().map(ArtifactSourceType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sourceTypes(Collection<ArtifactSourceType> sourceTypes) {
            this.sourceTypes = ArtifactSourceTypesCopier.copy(sourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceTypes(ArtifactSourceType ... sourceTypes) {
            this.sourceTypes(Arrays.asList(sourceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceTypes(Consumer<ArtifactSourceType.Builder> ... sourceTypes) {
            this.sourceTypes(Stream.of(sourceTypes).map(c -> (ArtifactSourceType)((ArtifactSourceType.Builder)ArtifactSourceType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSourceTypes(Collection<ArtifactSourceType.BuilderImpl> sourceTypes) {
            this.sourceTypes = ArtifactSourceTypesCopier.copyFromBuilder(sourceTypes);
        }

        public ArtifactSource build() {
            return new ArtifactSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArtifactSource> {
        public Builder sourceUri(String var1);

        public Builder sourceTypes(Collection<ArtifactSourceType> var1);

        public Builder sourceTypes(ArtifactSourceType ... var1);

        public Builder sourceTypes(Consumer<ArtifactSourceType.Builder> ... var1);
    }
}

