/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.RepositoryAccessMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageConfig> {
    private static final SdkField<String> REPOSITORY_ACCESS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryAccessMode").getter(ImageConfig.getter(ImageConfig::repositoryAccessModeAsString)).setter(ImageConfig.setter(Builder::repositoryAccessMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryAccessMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_ACCESS_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String repositoryAccessMode;

    private ImageConfig(BuilderImpl builder) {
        this.repositoryAccessMode = builder.repositoryAccessMode;
    }

    public final RepositoryAccessMode repositoryAccessMode() {
        return RepositoryAccessMode.fromValue(this.repositoryAccessMode);
    }

    public final String repositoryAccessModeAsString() {
        return this.repositoryAccessMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryAccessModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageConfig)) {
            return false;
        }
        ImageConfig other = (ImageConfig)obj;
        return Objects.equals(this.repositoryAccessModeAsString(), other.repositoryAccessModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImageConfig").add("RepositoryAccessMode", (Object)this.repositoryAccessModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RepositoryAccessMode": {
                return Optional.ofNullable(clazz.cast(this.repositoryAccessModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageConfig, T> g) {
        return obj -> g.apply((ImageConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String repositoryAccessMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageConfig model) {
            this.repositoryAccessMode(model.repositoryAccessMode);
        }

        public final String getRepositoryAccessMode() {
            return this.repositoryAccessMode;
        }

        @Override
        public final Builder repositoryAccessMode(String repositoryAccessMode) {
            this.repositoryAccessMode = repositoryAccessMode;
            return this;
        }

        @Override
        public final Builder repositoryAccessMode(RepositoryAccessMode repositoryAccessMode) {
            this.repositoryAccessMode(repositoryAccessMode == null ? null : repositoryAccessMode.toString());
            return this;
        }

        public final void setRepositoryAccessMode(String repositoryAccessMode) {
            this.repositoryAccessMode = repositoryAccessMode;
        }

        public ImageConfig build() {
            return new ImageConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageConfig> {
        public Builder repositoryAccessMode(String var1);

        public Builder repositoryAccessMode(RepositoryAccessMode var1);
    }
}

