/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ProjectStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisionedProductDetails;
import software.amazon.awssdk.services.sagemaker.model.ServiceCatalogProvisioningDetails;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProjectResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeProjectResponse> {
    private static final SdkField<String> PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectArn").getter(DescribeProjectResponse.getter(DescribeProjectResponse::projectArn)).setter(DescribeProjectResponse.setter(Builder::projectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectArn").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectName").getter(DescribeProjectResponse.getter(DescribeProjectResponse::projectName)).setter(DescribeProjectResponse.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()}).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectId").getter(DescribeProjectResponse.getter(DescribeProjectResponse::projectId)).setter(DescribeProjectResponse.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectId").build()}).build();
    private static final SdkField<String> PROJECT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectDescription").getter(DescribeProjectResponse.getter(DescribeProjectResponse::projectDescription)).setter(DescribeProjectResponse.setter(Builder::projectDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectDescription").build()}).build();
    private static final SdkField<ServiceCatalogProvisioningDetails> SERVICE_CATALOG_PROVISIONING_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceCatalogProvisioningDetails").getter(DescribeProjectResponse.getter(DescribeProjectResponse::serviceCatalogProvisioningDetails)).setter(DescribeProjectResponse.setter(Builder::serviceCatalogProvisioningDetails)).constructor(ServiceCatalogProvisioningDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCatalogProvisioningDetails").build()}).build();
    private static final SdkField<ServiceCatalogProvisionedProductDetails> SERVICE_CATALOG_PROVISIONED_PRODUCT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceCatalogProvisionedProductDetails").getter(DescribeProjectResponse.getter(DescribeProjectResponse::serviceCatalogProvisionedProductDetails)).setter(DescribeProjectResponse.setter(Builder::serviceCatalogProvisionedProductDetails)).constructor(ServiceCatalogProvisionedProductDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCatalogProvisionedProductDetails").build()}).build();
    private static final SdkField<String> PROJECT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectStatus").getter(DescribeProjectResponse.getter(DescribeProjectResponse::projectStatusAsString)).setter(DescribeProjectResponse.setter(Builder::projectStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectStatus").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(DescribeProjectResponse.getter(DescribeProjectResponse::createdBy)).setter(DescribeProjectResponse.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeProjectResponse.getter(DescribeProjectResponse::creationTime)).setter(DescribeProjectResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_ARN_FIELD, PROJECT_NAME_FIELD, PROJECT_ID_FIELD, PROJECT_DESCRIPTION_FIELD, SERVICE_CATALOG_PROVISIONING_DETAILS_FIELD, SERVICE_CATALOG_PROVISIONED_PRODUCT_DETAILS_FIELD, PROJECT_STATUS_FIELD, CREATED_BY_FIELD, CREATION_TIME_FIELD));
    private final String projectArn;
    private final String projectName;
    private final String projectId;
    private final String projectDescription;
    private final ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails;
    private final ServiceCatalogProvisionedProductDetails serviceCatalogProvisionedProductDetails;
    private final String projectStatus;
    private final UserContext createdBy;
    private final Instant creationTime;

    private DescribeProjectResponse(BuilderImpl builder) {
        super(builder);
        this.projectArn = builder.projectArn;
        this.projectName = builder.projectName;
        this.projectId = builder.projectId;
        this.projectDescription = builder.projectDescription;
        this.serviceCatalogProvisioningDetails = builder.serviceCatalogProvisioningDetails;
        this.serviceCatalogProvisionedProductDetails = builder.serviceCatalogProvisionedProductDetails;
        this.projectStatus = builder.projectStatus;
        this.createdBy = builder.createdBy;
        this.creationTime = builder.creationTime;
    }

    public final String projectArn() {
        return this.projectArn;
    }

    public final String projectName() {
        return this.projectName;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final String projectDescription() {
        return this.projectDescription;
    }

    public final ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails() {
        return this.serviceCatalogProvisioningDetails;
    }

    public final ServiceCatalogProvisionedProductDetails serviceCatalogProvisionedProductDetails() {
        return this.serviceCatalogProvisionedProductDetails;
    }

    public final ProjectStatus projectStatus() {
        return ProjectStatus.fromValue(this.projectStatus);
    }

    public final String projectStatusAsString() {
        return this.projectStatus;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.projectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCatalogProvisioningDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCatalogProvisionedProductDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectResponse)) {
            return false;
        }
        DescribeProjectResponse other = (DescribeProjectResponse)((Object)obj);
        return Objects.equals(this.projectArn(), other.projectArn()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.projectDescription(), other.projectDescription()) && Objects.equals(this.serviceCatalogProvisioningDetails(), other.serviceCatalogProvisioningDetails()) && Objects.equals(this.serviceCatalogProvisionedProductDetails(), other.serviceCatalogProvisionedProductDetails()) && Objects.equals(this.projectStatusAsString(), other.projectStatusAsString()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProjectResponse").add("ProjectArn", (Object)this.projectArn()).add("ProjectName", (Object)this.projectName()).add("ProjectId", (Object)this.projectId()).add("ProjectDescription", (Object)this.projectDescription()).add("ServiceCatalogProvisioningDetails", (Object)this.serviceCatalogProvisioningDetails()).add("ServiceCatalogProvisionedProductDetails", (Object)this.serviceCatalogProvisionedProductDetails()).add("ProjectStatus", (Object)this.projectStatusAsString()).add("CreatedBy", (Object)this.createdBy()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectArn": {
                return Optional.ofNullable(clazz.cast(this.projectArn()));
            }
            case "ProjectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "ProjectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "ProjectDescription": {
                return Optional.ofNullable(clazz.cast(this.projectDescription()));
            }
            case "ServiceCatalogProvisioningDetails": {
                return Optional.ofNullable(clazz.cast(this.serviceCatalogProvisioningDetails()));
            }
            case "ServiceCatalogProvisionedProductDetails": {
                return Optional.ofNullable(clazz.cast(this.serviceCatalogProvisionedProductDetails()));
            }
            case "ProjectStatus": {
                return Optional.ofNullable(clazz.cast(this.projectStatusAsString()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectResponse, T> g) {
        return obj -> g.apply((DescribeProjectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String projectArn;
        private String projectName;
        private String projectId;
        private String projectDescription;
        private ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails;
        private ServiceCatalogProvisionedProductDetails serviceCatalogProvisionedProductDetails;
        private String projectStatus;
        private UserContext createdBy;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectResponse model) {
            super(model);
            this.projectArn(model.projectArn);
            this.projectName(model.projectName);
            this.projectId(model.projectId);
            this.projectDescription(model.projectDescription);
            this.serviceCatalogProvisioningDetails(model.serviceCatalogProvisioningDetails);
            this.serviceCatalogProvisionedProductDetails(model.serviceCatalogProvisionedProductDetails);
            this.projectStatus(model.projectStatus);
            this.createdBy(model.createdBy);
            this.creationTime(model.creationTime);
        }

        public final String getProjectArn() {
            return this.projectArn;
        }

        @Override
        public final Builder projectArn(String projectArn) {
            this.projectArn = projectArn;
            return this;
        }

        public final void setProjectArn(String projectArn) {
            this.projectArn = projectArn;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final String getProjectId() {
            return this.projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public final String getProjectDescription() {
            return this.projectDescription;
        }

        @Override
        public final Builder projectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public final void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        public final ServiceCatalogProvisioningDetails.Builder getServiceCatalogProvisioningDetails() {
            return this.serviceCatalogProvisioningDetails != null ? this.serviceCatalogProvisioningDetails.toBuilder() : null;
        }

        @Override
        public final Builder serviceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails) {
            this.serviceCatalogProvisioningDetails = serviceCatalogProvisioningDetails;
            return this;
        }

        public final void setServiceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails.BuilderImpl serviceCatalogProvisioningDetails) {
            this.serviceCatalogProvisioningDetails = serviceCatalogProvisioningDetails != null ? serviceCatalogProvisioningDetails.build() : null;
        }

        public final ServiceCatalogProvisionedProductDetails.Builder getServiceCatalogProvisionedProductDetails() {
            return this.serviceCatalogProvisionedProductDetails != null ? this.serviceCatalogProvisionedProductDetails.toBuilder() : null;
        }

        @Override
        public final Builder serviceCatalogProvisionedProductDetails(ServiceCatalogProvisionedProductDetails serviceCatalogProvisionedProductDetails) {
            this.serviceCatalogProvisionedProductDetails = serviceCatalogProvisionedProductDetails;
            return this;
        }

        public final void setServiceCatalogProvisionedProductDetails(ServiceCatalogProvisionedProductDetails.BuilderImpl serviceCatalogProvisionedProductDetails) {
            this.serviceCatalogProvisionedProductDetails = serviceCatalogProvisionedProductDetails != null ? serviceCatalogProvisionedProductDetails.build() : null;
        }

        public final String getProjectStatus() {
            return this.projectStatus;
        }

        @Override
        public final Builder projectStatus(String projectStatus) {
            this.projectStatus = projectStatus;
            return this;
        }

        @Override
        public final Builder projectStatus(ProjectStatus projectStatus) {
            this.projectStatus(projectStatus == null ? null : projectStatus.toString());
            return this;
        }

        public final void setProjectStatus(String projectStatus) {
            this.projectStatus = projectStatus;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public DescribeProjectResponse build() {
            return new DescribeProjectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProjectResponse> {
        public Builder projectArn(String var1);

        public Builder projectName(String var1);

        public Builder projectId(String var1);

        public Builder projectDescription(String var1);

        public Builder serviceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails var1);

        default public Builder serviceCatalogProvisioningDetails(Consumer<ServiceCatalogProvisioningDetails.Builder> serviceCatalogProvisioningDetails) {
            return this.serviceCatalogProvisioningDetails((ServiceCatalogProvisioningDetails)((ServiceCatalogProvisioningDetails.Builder)ServiceCatalogProvisioningDetails.builder().applyMutation(serviceCatalogProvisioningDetails)).build());
        }

        public Builder serviceCatalogProvisionedProductDetails(ServiceCatalogProvisionedProductDetails var1);

        default public Builder serviceCatalogProvisionedProductDetails(Consumer<ServiceCatalogProvisionedProductDetails.Builder> serviceCatalogProvisionedProductDetails) {
            return this.serviceCatalogProvisionedProductDetails((ServiceCatalogProvisionedProductDetails)((ServiceCatalogProvisionedProductDetails.Builder)ServiceCatalogProvisionedProductDetails.builder().applyMutation(serviceCatalogProvisionedProductDetails)).build());
        }

        public Builder projectStatus(String var1);

        public Builder projectStatus(ProjectStatus var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder creationTime(Instant var1);
    }
}

