/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.EdgeOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.EdgePackagingJobStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEdgePackagingJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeEdgePackagingJobResponse> {
    private static final SdkField<String> EDGE_PACKAGING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgePackagingJobArn").getter(DescribeEdgePackagingJobResponse.getter(DescribeEdgePackagingJobResponse::edgePackagingJobArn)).setter(DescribeEdgePackagingJobResponse.setter(Builder::edgePackagingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobArn").build()}).build();
    private static final SdkField<String> EDGE_PACKAGING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgePackagingJobName").getter(DescribeEdgePackagingJobResponse.getter(DescribeEdgePackagingJobResponse::edgePackagingJobName)).setter(DescribeEdgePackagingJobResponse.setter(Builder::edgePackagingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobName").build()}).build();
    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationJobName").getter(DescribeEdgePackagingJobResponse.getter(DescribeEdgePackagingJobResponse::compilationJobName)).setter(DescribeEdgePackagingJobResponse.setter(Builder::compilationJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(DescribeEdgePackagingJobResponse.getter(DescribeEdgePackagingJobResponse::modelName)).setter(DescribeEdgePackagingJobResponse.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersion").getter(DescribeEdgePackagingJobResponse.getter(DescribeEdgePackagingJobResponse::modelVersion)).setter(DescribeEdgePackagingJobResponse.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeEdgePackagingJobResponse.getter(DescribeEdgePackagingJobResponse::roleArn)).setter(DescribeEdgePackagingJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<EdgeOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(DescribeEdgePackagingJobResponse.getter(DescribeEdgePackagingJobResponse::outputConfig)).setter(DescribeEdgePackagingJobResponse.setter(Builder::outputConfig)).constructor(EdgeOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<String> RESOURCE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceKey").getter(DescribeEdgePackagingJobResponse.getter(DescribeEdgePackagingJobResponse::resourceKey)).setter(DescribeEdgePackagingJobResponse.setter(Builder::resourceKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceKey").build()}).build();
    private static final SdkField<String> EDGE_PACKAGING_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgePackagingJobStatus").getter(DescribeEdgePackagingJobResponse.getter(DescribeEdgePackagingJobResponse::edgePackagingJobStatusAsString)).setter(DescribeEdgePackagingJobResponse.setter(Builder::edgePackagingJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobStatus").build()}).build();
    private static final SdkField<String> EDGE_PACKAGING_JOB_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EdgePackagingJobStatusMessage").getter(DescribeEdgePackagingJobResponse.getter(DescribeEdgePackagingJobResponse::edgePackagingJobStatusMessage)).setter(DescribeEdgePackagingJobResponse.setter(Builder::edgePackagingJobStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobStatusMessage").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeEdgePackagingJobResponse.getter(DescribeEdgePackagingJobResponse::creationTime)).setter(DescribeEdgePackagingJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeEdgePackagingJobResponse.getter(DescribeEdgePackagingJobResponse::lastModifiedTime)).setter(DescribeEdgePackagingJobResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> MODEL_ARTIFACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArtifact").getter(DescribeEdgePackagingJobResponse.getter(DescribeEdgePackagingJobResponse::modelArtifact)).setter(DescribeEdgePackagingJobResponse.setter(Builder::modelArtifact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArtifact").build()}).build();
    private static final SdkField<String> MODEL_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelSignature").getter(DescribeEdgePackagingJobResponse.getter(DescribeEdgePackagingJobResponse::modelSignature)).setter(DescribeEdgePackagingJobResponse.setter(Builder::modelSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelSignature").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_PACKAGING_JOB_ARN_FIELD, EDGE_PACKAGING_JOB_NAME_FIELD, COMPILATION_JOB_NAME_FIELD, MODEL_NAME_FIELD, MODEL_VERSION_FIELD, ROLE_ARN_FIELD, OUTPUT_CONFIG_FIELD, RESOURCE_KEY_FIELD, EDGE_PACKAGING_JOB_STATUS_FIELD, EDGE_PACKAGING_JOB_STATUS_MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, MODEL_ARTIFACT_FIELD, MODEL_SIGNATURE_FIELD));
    private final String edgePackagingJobArn;
    private final String edgePackagingJobName;
    private final String compilationJobName;
    private final String modelName;
    private final String modelVersion;
    private final String roleArn;
    private final EdgeOutputConfig outputConfig;
    private final String resourceKey;
    private final String edgePackagingJobStatus;
    private final String edgePackagingJobStatusMessage;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String modelArtifact;
    private final String modelSignature;

    private DescribeEdgePackagingJobResponse(BuilderImpl builder) {
        super(builder);
        this.edgePackagingJobArn = builder.edgePackagingJobArn;
        this.edgePackagingJobName = builder.edgePackagingJobName;
        this.compilationJobName = builder.compilationJobName;
        this.modelName = builder.modelName;
        this.modelVersion = builder.modelVersion;
        this.roleArn = builder.roleArn;
        this.outputConfig = builder.outputConfig;
        this.resourceKey = builder.resourceKey;
        this.edgePackagingJobStatus = builder.edgePackagingJobStatus;
        this.edgePackagingJobStatusMessage = builder.edgePackagingJobStatusMessage;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.modelArtifact = builder.modelArtifact;
        this.modelSignature = builder.modelSignature;
    }

    public String edgePackagingJobArn() {
        return this.edgePackagingJobArn;
    }

    public String edgePackagingJobName() {
        return this.edgePackagingJobName;
    }

    public String compilationJobName() {
        return this.compilationJobName;
    }

    public String modelName() {
        return this.modelName;
    }

    public String modelVersion() {
        return this.modelVersion;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public EdgeOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public String resourceKey() {
        return this.resourceKey;
    }

    public EdgePackagingJobStatus edgePackagingJobStatus() {
        return EdgePackagingJobStatus.fromValue(this.edgePackagingJobStatus);
    }

    public String edgePackagingJobStatusAsString() {
        return this.edgePackagingJobStatus;
    }

    public String edgePackagingJobStatusMessage() {
        return this.edgePackagingJobStatusMessage;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String modelArtifact() {
        return this.modelArtifact;
    }

    public String modelSignature() {
        return this.modelSignature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.edgePackagingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgePackagingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgePackagingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgePackagingJobStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArtifact());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSignature());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEdgePackagingJobResponse)) {
            return false;
        }
        DescribeEdgePackagingJobResponse other = (DescribeEdgePackagingJobResponse)((Object)obj);
        return Objects.equals(this.edgePackagingJobArn(), other.edgePackagingJobArn()) && Objects.equals(this.edgePackagingJobName(), other.edgePackagingJobName()) && Objects.equals(this.compilationJobName(), other.compilationJobName()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.resourceKey(), other.resourceKey()) && Objects.equals(this.edgePackagingJobStatusAsString(), other.edgePackagingJobStatusAsString()) && Objects.equals(this.edgePackagingJobStatusMessage(), other.edgePackagingJobStatusMessage()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.modelArtifact(), other.modelArtifact()) && Objects.equals(this.modelSignature(), other.modelSignature());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEdgePackagingJobResponse").add("EdgePackagingJobArn", (Object)this.edgePackagingJobArn()).add("EdgePackagingJobName", (Object)this.edgePackagingJobName()).add("CompilationJobName", (Object)this.compilationJobName()).add("ModelName", (Object)this.modelName()).add("ModelVersion", (Object)this.modelVersion()).add("RoleArn", (Object)this.roleArn()).add("OutputConfig", (Object)this.outputConfig()).add("ResourceKey", (Object)this.resourceKey()).add("EdgePackagingJobStatus", (Object)this.edgePackagingJobStatusAsString()).add("EdgePackagingJobStatusMessage", (Object)this.edgePackagingJobStatusMessage()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("ModelArtifact", (Object)this.modelArtifact()).add("ModelSignature", (Object)this.modelSignature()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EdgePackagingJobArn": {
                return Optional.ofNullable(clazz.cast(this.edgePackagingJobArn()));
            }
            case "EdgePackagingJobName": {
                return Optional.ofNullable(clazz.cast(this.edgePackagingJobName()));
            }
            case "CompilationJobName": {
                return Optional.ofNullable(clazz.cast(this.compilationJobName()));
            }
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "ResourceKey": {
                return Optional.ofNullable(clazz.cast(this.resourceKey()));
            }
            case "EdgePackagingJobStatus": {
                return Optional.ofNullable(clazz.cast(this.edgePackagingJobStatusAsString()));
            }
            case "EdgePackagingJobStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.edgePackagingJobStatusMessage()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "ModelArtifact": {
                return Optional.ofNullable(clazz.cast(this.modelArtifact()));
            }
            case "ModelSignature": {
                return Optional.ofNullable(clazz.cast(this.modelSignature()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEdgePackagingJobResponse, T> g) {
        return obj -> g.apply((DescribeEdgePackagingJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String edgePackagingJobArn;
        private String edgePackagingJobName;
        private String compilationJobName;
        private String modelName;
        private String modelVersion;
        private String roleArn;
        private EdgeOutputConfig outputConfig;
        private String resourceKey;
        private String edgePackagingJobStatus;
        private String edgePackagingJobStatusMessage;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String modelArtifact;
        private String modelSignature;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEdgePackagingJobResponse model) {
            super(model);
            this.edgePackagingJobArn(model.edgePackagingJobArn);
            this.edgePackagingJobName(model.edgePackagingJobName);
            this.compilationJobName(model.compilationJobName);
            this.modelName(model.modelName);
            this.modelVersion(model.modelVersion);
            this.roleArn(model.roleArn);
            this.outputConfig(model.outputConfig);
            this.resourceKey(model.resourceKey);
            this.edgePackagingJobStatus(model.edgePackagingJobStatus);
            this.edgePackagingJobStatusMessage(model.edgePackagingJobStatusMessage);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.modelArtifact(model.modelArtifact);
            this.modelSignature(model.modelSignature);
        }

        public final String getEdgePackagingJobArn() {
            return this.edgePackagingJobArn;
        }

        @Override
        public final Builder edgePackagingJobArn(String edgePackagingJobArn) {
            this.edgePackagingJobArn = edgePackagingJobArn;
            return this;
        }

        public final void setEdgePackagingJobArn(String edgePackagingJobArn) {
            this.edgePackagingJobArn = edgePackagingJobArn;
        }

        public final String getEdgePackagingJobName() {
            return this.edgePackagingJobName;
        }

        @Override
        public final Builder edgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
            return this;
        }

        public final void setEdgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
        }

        public final String getCompilationJobName() {
            return this.compilationJobName;
        }

        @Override
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        public final String getModelName() {
            return this.modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final String getModelVersion() {
            return this.modelVersion;
        }

        @Override
        public final Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final EdgeOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(EdgeOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(EdgeOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final String getResourceKey() {
            return this.resourceKey;
        }

        @Override
        public final Builder resourceKey(String resourceKey) {
            this.resourceKey = resourceKey;
            return this;
        }

        public final void setResourceKey(String resourceKey) {
            this.resourceKey = resourceKey;
        }

        public final String getEdgePackagingJobStatus() {
            return this.edgePackagingJobStatus;
        }

        @Override
        public final Builder edgePackagingJobStatus(String edgePackagingJobStatus) {
            this.edgePackagingJobStatus = edgePackagingJobStatus;
            return this;
        }

        @Override
        public final Builder edgePackagingJobStatus(EdgePackagingJobStatus edgePackagingJobStatus) {
            this.edgePackagingJobStatus(edgePackagingJobStatus == null ? null : edgePackagingJobStatus.toString());
            return this;
        }

        public final void setEdgePackagingJobStatus(String edgePackagingJobStatus) {
            this.edgePackagingJobStatus = edgePackagingJobStatus;
        }

        public final String getEdgePackagingJobStatusMessage() {
            return this.edgePackagingJobStatusMessage;
        }

        @Override
        public final Builder edgePackagingJobStatusMessage(String edgePackagingJobStatusMessage) {
            this.edgePackagingJobStatusMessage = edgePackagingJobStatusMessage;
            return this;
        }

        public final void setEdgePackagingJobStatusMessage(String edgePackagingJobStatusMessage) {
            this.edgePackagingJobStatusMessage = edgePackagingJobStatusMessage;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getModelArtifact() {
            return this.modelArtifact;
        }

        @Override
        public final Builder modelArtifact(String modelArtifact) {
            this.modelArtifact = modelArtifact;
            return this;
        }

        public final void setModelArtifact(String modelArtifact) {
            this.modelArtifact = modelArtifact;
        }

        public final String getModelSignature() {
            return this.modelSignature;
        }

        @Override
        public final Builder modelSignature(String modelSignature) {
            this.modelSignature = modelSignature;
            return this;
        }

        public final void setModelSignature(String modelSignature) {
            this.modelSignature = modelSignature;
        }

        @Override
        public DescribeEdgePackagingJobResponse build() {
            return new DescribeEdgePackagingJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEdgePackagingJobResponse> {
        public Builder edgePackagingJobArn(String var1);

        public Builder edgePackagingJobName(String var1);

        public Builder compilationJobName(String var1);

        public Builder modelName(String var1);

        public Builder modelVersion(String var1);

        public Builder roleArn(String var1);

        public Builder outputConfig(EdgeOutputConfig var1);

        default public Builder outputConfig(Consumer<EdgeOutputConfig.Builder> outputConfig) {
            return this.outputConfig((EdgeOutputConfig)((EdgeOutputConfig.Builder)EdgeOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder resourceKey(String var1);

        public Builder edgePackagingJobStatus(String var1);

        public Builder edgePackagingJobStatus(EdgePackagingJobStatus var1);

        public Builder edgePackagingJobStatusMessage(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder modelArtifact(String var1);

        public Builder modelSignature(String var1);
    }
}

