/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.DatasetDefinition;
import software.amazon.awssdk.services.sagemaker.model.ProcessingS3Input;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProcessingInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProcessingInput> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputName").getter(ProcessingInput.getter(ProcessingInput::inputName)).setter(ProcessingInput.setter(Builder::inputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputName").build()}).build();
    private static final SdkField<Boolean> APP_MANAGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AppManaged").getter(ProcessingInput.getter(ProcessingInput::appManaged)).setter(ProcessingInput.setter(Builder::appManaged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppManaged").build()}).build();
    private static final SdkField<ProcessingS3Input> S3_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Input").getter(ProcessingInput.getter(ProcessingInput::s3Input)).setter(ProcessingInput.setter(Builder::s3Input)).constructor(ProcessingS3Input::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Input").build()}).build();
    private static final SdkField<DatasetDefinition> DATASET_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatasetDefinition").getter(ProcessingInput.getter(ProcessingInput::datasetDefinition)).setter(ProcessingInput.setter(Builder::datasetDefinition)).constructor(DatasetDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD, APP_MANAGED_FIELD, S3_INPUT_FIELD, DATASET_DEFINITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputName;
    private final Boolean appManaged;
    private final ProcessingS3Input s3Input;
    private final DatasetDefinition datasetDefinition;

    private ProcessingInput(BuilderImpl builder) {
        this.inputName = builder.inputName;
        this.appManaged = builder.appManaged;
        this.s3Input = builder.s3Input;
        this.datasetDefinition = builder.datasetDefinition;
    }

    public String inputName() {
        return this.inputName;
    }

    public Boolean appManaged() {
        return this.appManaged;
    }

    public ProcessingS3Input s3Input() {
        return this.s3Input;
    }

    public DatasetDefinition datasetDefinition() {
        return this.datasetDefinition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputName());
        hashCode = 31 * hashCode + Objects.hashCode(this.appManaged());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Input());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetDefinition());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingInput)) {
            return false;
        }
        ProcessingInput other = (ProcessingInput)obj;
        return Objects.equals(this.inputName(), other.inputName()) && Objects.equals(this.appManaged(), other.appManaged()) && Objects.equals(this.s3Input(), other.s3Input()) && Objects.equals(this.datasetDefinition(), other.datasetDefinition());
    }

    public String toString() {
        return ToString.builder((String)"ProcessingInput").add("InputName", (Object)this.inputName()).add("AppManaged", (Object)this.appManaged()).add("S3Input", (Object)this.s3Input()).add("DatasetDefinition", (Object)this.datasetDefinition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputName": {
                return Optional.ofNullable(clazz.cast(this.inputName()));
            }
            case "AppManaged": {
                return Optional.ofNullable(clazz.cast(this.appManaged()));
            }
            case "S3Input": {
                return Optional.ofNullable(clazz.cast(this.s3Input()));
            }
            case "DatasetDefinition": {
                return Optional.ofNullable(clazz.cast(this.datasetDefinition()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingInput, T> g) {
        return obj -> g.apply((ProcessingInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputName;
        private Boolean appManaged;
        private ProcessingS3Input s3Input;
        private DatasetDefinition datasetDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingInput model) {
            this.inputName(model.inputName);
            this.appManaged(model.appManaged);
            this.s3Input(model.s3Input);
            this.datasetDefinition(model.datasetDefinition);
        }

        public final String getInputName() {
            return this.inputName;
        }

        @Override
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        public final Boolean getAppManaged() {
            return this.appManaged;
        }

        @Override
        public final Builder appManaged(Boolean appManaged) {
            this.appManaged = appManaged;
            return this;
        }

        public final void setAppManaged(Boolean appManaged) {
            this.appManaged = appManaged;
        }

        public final ProcessingS3Input.Builder getS3Input() {
            return this.s3Input != null ? this.s3Input.toBuilder() : null;
        }

        @Override
        public final Builder s3Input(ProcessingS3Input s3Input) {
            this.s3Input = s3Input;
            return this;
        }

        public final void setS3Input(ProcessingS3Input.BuilderImpl s3Input) {
            this.s3Input = s3Input != null ? s3Input.build() : null;
        }

        public final DatasetDefinition.Builder getDatasetDefinition() {
            return this.datasetDefinition != null ? this.datasetDefinition.toBuilder() : null;
        }

        @Override
        public final Builder datasetDefinition(DatasetDefinition datasetDefinition) {
            this.datasetDefinition = datasetDefinition;
            return this;
        }

        public final void setDatasetDefinition(DatasetDefinition.BuilderImpl datasetDefinition) {
            this.datasetDefinition = datasetDefinition != null ? datasetDefinition.build() : null;
        }

        public ProcessingInput build() {
            return new ProcessingInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProcessingInput> {
        public Builder inputName(String var1);

        public Builder appManaged(Boolean var1);

        public Builder s3Input(ProcessingS3Input var1);

        default public Builder s3Input(Consumer<ProcessingS3Input.Builder> s3Input) {
            return this.s3Input((ProcessingS3Input)((ProcessingS3Input.Builder)ProcessingS3Input.builder().applyMutation(s3Input)).build());
        }

        public Builder datasetDefinition(DatasetDefinition var1);

        default public Builder datasetDefinition(Consumer<DatasetDefinition.Builder> datasetDefinition) {
            return this.datasetDefinition((DatasetDefinition)((DatasetDefinition.Builder)DatasetDefinition.builder().applyMutation(datasetDefinition)).build());
        }
    }
}

