/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.Bias;
import software.amazon.awssdk.services.sagemaker.model.Explainability;
import software.amazon.awssdk.services.sagemaker.model.ModelDataQuality;
import software.amazon.awssdk.services.sagemaker.model.ModelQuality;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelMetrics> {
    private static final SdkField<ModelQuality> MODEL_QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelQuality").getter(ModelMetrics.getter(ModelMetrics::modelQuality)).setter(ModelMetrics.setter(Builder::modelQuality)).constructor(ModelQuality::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQuality").build()}).build();
    private static final SdkField<ModelDataQuality> MODEL_DATA_QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelDataQuality").getter(ModelMetrics.getter(ModelMetrics::modelDataQuality)).setter(ModelMetrics.setter(Builder::modelDataQuality)).constructor(ModelDataQuality::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataQuality").build()}).build();
    private static final SdkField<Bias> BIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Bias").getter(ModelMetrics.getter(ModelMetrics::bias)).setter(ModelMetrics.setter(Builder::bias)).constructor(Bias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bias").build()}).build();
    private static final SdkField<Explainability> EXPLAINABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Explainability").getter(ModelMetrics.getter(ModelMetrics::explainability)).setter(ModelMetrics.setter(Builder::explainability)).constructor(Explainability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Explainability").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_QUALITY_FIELD, MODEL_DATA_QUALITY_FIELD, BIAS_FIELD, EXPLAINABILITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final ModelQuality modelQuality;
    private final ModelDataQuality modelDataQuality;
    private final Bias bias;
    private final Explainability explainability;

    private ModelMetrics(BuilderImpl builder) {
        this.modelQuality = builder.modelQuality;
        this.modelDataQuality = builder.modelDataQuality;
        this.bias = builder.bias;
        this.explainability = builder.explainability;
    }

    public ModelQuality modelQuality() {
        return this.modelQuality;
    }

    public ModelDataQuality modelDataQuality() {
        return this.modelDataQuality;
    }

    public Bias bias() {
        return this.bias;
    }

    public Explainability explainability() {
        return this.explainability;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelQuality());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataQuality());
        hashCode = 31 * hashCode + Objects.hashCode(this.bias());
        hashCode = 31 * hashCode + Objects.hashCode(this.explainability());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelMetrics)) {
            return false;
        }
        ModelMetrics other = (ModelMetrics)obj;
        return Objects.equals(this.modelQuality(), other.modelQuality()) && Objects.equals(this.modelDataQuality(), other.modelDataQuality()) && Objects.equals(this.bias(), other.bias()) && Objects.equals(this.explainability(), other.explainability());
    }

    public String toString() {
        return ToString.builder((String)"ModelMetrics").add("ModelQuality", (Object)this.modelQuality()).add("ModelDataQuality", (Object)this.modelDataQuality()).add("Bias", (Object)this.bias()).add("Explainability", (Object)this.explainability()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelQuality": {
                return Optional.ofNullable(clazz.cast(this.modelQuality()));
            }
            case "ModelDataQuality": {
                return Optional.ofNullable(clazz.cast(this.modelDataQuality()));
            }
            case "Bias": {
                return Optional.ofNullable(clazz.cast(this.bias()));
            }
            case "Explainability": {
                return Optional.ofNullable(clazz.cast(this.explainability()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelMetrics, T> g) {
        return obj -> g.apply((ModelMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ModelQuality modelQuality;
        private ModelDataQuality modelDataQuality;
        private Bias bias;
        private Explainability explainability;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelMetrics model) {
            this.modelQuality(model.modelQuality);
            this.modelDataQuality(model.modelDataQuality);
            this.bias(model.bias);
            this.explainability(model.explainability);
        }

        public final ModelQuality.Builder getModelQuality() {
            return this.modelQuality != null ? this.modelQuality.toBuilder() : null;
        }

        @Override
        public final Builder modelQuality(ModelQuality modelQuality) {
            this.modelQuality = modelQuality;
            return this;
        }

        public final void setModelQuality(ModelQuality.BuilderImpl modelQuality) {
            this.modelQuality = modelQuality != null ? modelQuality.build() : null;
        }

        public final ModelDataQuality.Builder getModelDataQuality() {
            return this.modelDataQuality != null ? this.modelDataQuality.toBuilder() : null;
        }

        @Override
        public final Builder modelDataQuality(ModelDataQuality modelDataQuality) {
            this.modelDataQuality = modelDataQuality;
            return this;
        }

        public final void setModelDataQuality(ModelDataQuality.BuilderImpl modelDataQuality) {
            this.modelDataQuality = modelDataQuality != null ? modelDataQuality.build() : null;
        }

        public final Bias.Builder getBias() {
            return this.bias != null ? this.bias.toBuilder() : null;
        }

        @Override
        public final Builder bias(Bias bias) {
            this.bias = bias;
            return this;
        }

        public final void setBias(Bias.BuilderImpl bias) {
            this.bias = bias != null ? bias.build() : null;
        }

        public final Explainability.Builder getExplainability() {
            return this.explainability != null ? this.explainability.toBuilder() : null;
        }

        @Override
        public final Builder explainability(Explainability explainability) {
            this.explainability = explainability;
            return this;
        }

        public final void setExplainability(Explainability.BuilderImpl explainability) {
            this.explainability = explainability != null ? explainability.build() : null;
        }

        public ModelMetrics build() {
            return new ModelMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelMetrics> {
        public Builder modelQuality(ModelQuality var1);

        default public Builder modelQuality(Consumer<ModelQuality.Builder> modelQuality) {
            return this.modelQuality((ModelQuality)((ModelQuality.Builder)ModelQuality.builder().applyMutation(modelQuality)).build());
        }

        public Builder modelDataQuality(ModelDataQuality var1);

        default public Builder modelDataQuality(Consumer<ModelDataQuality.Builder> modelDataQuality) {
            return this.modelDataQuality((ModelDataQuality)((ModelDataQuality.Builder)ModelDataQuality.builder().applyMutation(modelDataQuality)).build());
        }

        public Builder bias(Bias var1);

        default public Builder bias(Consumer<Bias.Builder> bias) {
            return this.bias((Bias)((Bias.Builder)Bias.builder().applyMutation(bias)).build());
        }

        public Builder explainability(Explainability var1);

        default public Builder explainability(Consumer<Explainability.Builder> explainability) {
            return this.explainability((Explainability)((Explainability.Builder)Explainability.builder().applyMutation(explainability)).build());
        }
    }
}

