/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.FeatureGroupSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.FeatureGroupSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFeatureGroupsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListFeatureGroupsResponse> {
    private static final SdkField<List<FeatureGroupSummary>> FEATURE_GROUP_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureGroupSummaries").getter(ListFeatureGroupsResponse.getter(ListFeatureGroupsResponse::featureGroupSummaries)).setter(ListFeatureGroupsResponse.setter(Builder::featureGroupSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeatureGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFeatureGroupsResponse.getter(ListFeatureGroupsResponse::nextToken)).setter(ListFeatureGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<FeatureGroupSummary> featureGroupSummaries;
    private final String nextToken;

    private ListFeatureGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.featureGroupSummaries = builder.featureGroupSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasFeatureGroupSummaries() {
        return this.featureGroupSummaries != null && !(this.featureGroupSummaries instanceof SdkAutoConstructList);
    }

    public List<FeatureGroupSummary> featureGroupSummaries() {
        return this.featureGroupSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureGroupSummaries() ? this.featureGroupSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFeatureGroupsResponse)) {
            return false;
        }
        ListFeatureGroupsResponse other = (ListFeatureGroupsResponse)((Object)obj);
        return this.hasFeatureGroupSummaries() == other.hasFeatureGroupSummaries() && Objects.equals(this.featureGroupSummaries(), other.featureGroupSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListFeatureGroupsResponse").add("FeatureGroupSummaries", this.hasFeatureGroupSummaries() ? this.featureGroupSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureGroupSummaries": {
                return Optional.ofNullable(clazz.cast(this.featureGroupSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFeatureGroupsResponse, T> g) {
        return obj -> g.apply((ListFeatureGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<FeatureGroupSummary> featureGroupSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFeatureGroupsResponse model) {
            super(model);
            this.featureGroupSummaries(model.featureGroupSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<FeatureGroupSummary.Builder> getFeatureGroupSummaries() {
            if (this.featureGroupSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.featureGroupSummaries != null ? (Collection)this.featureGroupSummaries.stream().map(FeatureGroupSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder featureGroupSummaries(Collection<FeatureGroupSummary> featureGroupSummaries) {
            this.featureGroupSummaries = FeatureGroupSummariesCopier.copy(featureGroupSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureGroupSummaries(FeatureGroupSummary ... featureGroupSummaries) {
            this.featureGroupSummaries(Arrays.asList(featureGroupSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureGroupSummaries(Consumer<FeatureGroupSummary.Builder> ... featureGroupSummaries) {
            this.featureGroupSummaries(Stream.of(featureGroupSummaries).map(c -> (FeatureGroupSummary)((FeatureGroupSummary.Builder)FeatureGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFeatureGroupSummaries(Collection<FeatureGroupSummary.BuilderImpl> featureGroupSummaries) {
            this.featureGroupSummaries = FeatureGroupSummariesCopier.copyFromBuilder(featureGroupSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFeatureGroupsResponse build() {
            return new ListFeatureGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFeatureGroupsResponse> {
        public Builder featureGroupSummaries(Collection<FeatureGroupSummary> var1);

        public Builder featureGroupSummaries(FeatureGroupSummary ... var1);

        public Builder featureGroupSummaries(Consumer<FeatureGroupSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

