/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddAssociationResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, AddAssociationResponse> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(AddAssociationResponse.getter(AddAssociationResponse::sourceArn)).setter(AddAssociationResponse.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationArn").getter(AddAssociationResponse.getter(AddAssociationResponse::destinationArn)).setter(AddAssociationResponse.setter(Builder::destinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD, DESTINATION_ARN_FIELD));
    private final String sourceArn;
    private final String destinationArn;

    private AddAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.sourceArn = builder.sourceArn;
        this.destinationArn = builder.destinationArn;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public String destinationArn() {
        return this.destinationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddAssociationResponse)) {
            return false;
        }
        AddAssociationResponse other = (AddAssociationResponse)((Object)obj);
        return Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.destinationArn(), other.destinationArn());
    }

    public String toString() {
        return ToString.builder((String)"AddAssociationResponse").add("SourceArn", (Object)this.sourceArn()).add("DestinationArn", (Object)this.destinationArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "DestinationArn": {
                return Optional.ofNullable(clazz.cast(this.destinationArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddAssociationResponse, T> g) {
        return obj -> g.apply((AddAssociationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String sourceArn;
        private String destinationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AddAssociationResponse model) {
            super(model);
            this.sourceArn(model.sourceArn);
            this.destinationArn(model.destinationArn);
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getDestinationArn() {
            return this.destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public AddAssociationResponse build() {
            return new AddAssociationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddAssociationResponse> {
        public Builder sourceArn(String var1);

        public Builder destinationArn(String var1);
    }
}

