/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePresignedNotebookInstanceUrlRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreatePresignedNotebookInstanceUrlRequest> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookInstanceName").getter(CreatePresignedNotebookInstanceUrlRequest.getter(CreatePresignedNotebookInstanceUrlRequest::notebookInstanceName)).setter(CreatePresignedNotebookInstanceUrlRequest.setter(Builder::notebookInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceName").build()}).build();
    private static final SdkField<Integer> SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionExpirationDurationInSeconds").getter(CreatePresignedNotebookInstanceUrlRequest.getter(CreatePresignedNotebookInstanceUrlRequest::sessionExpirationDurationInSeconds)).setter(CreatePresignedNotebookInstanceUrlRequest.setter(Builder::sessionExpirationDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionExpirationDurationInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_INSTANCE_NAME_FIELD, SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD));
    private final String notebookInstanceName;
    private final Integer sessionExpirationDurationInSeconds;

    private CreatePresignedNotebookInstanceUrlRequest(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceName = builder.notebookInstanceName;
        this.sessionExpirationDurationInSeconds = builder.sessionExpirationDurationInSeconds;
    }

    public String notebookInstanceName() {
        return this.notebookInstanceName;
    }

    public Integer sessionExpirationDurationInSeconds() {
        return this.sessionExpirationDurationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionExpirationDurationInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresignedNotebookInstanceUrlRequest)) {
            return false;
        }
        CreatePresignedNotebookInstanceUrlRequest other = (CreatePresignedNotebookInstanceUrlRequest)((Object)obj);
        return Objects.equals(this.notebookInstanceName(), other.notebookInstanceName()) && Objects.equals(this.sessionExpirationDurationInSeconds(), other.sessionExpirationDurationInSeconds());
    }

    public String toString() {
        return ToString.builder((String)"CreatePresignedNotebookInstanceUrlRequest").add("NotebookInstanceName", (Object)this.notebookInstanceName()).add("SessionExpirationDurationInSeconds", (Object)this.sessionExpirationDurationInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookInstanceName": {
                return Optional.ofNullable(clazz.cast(this.notebookInstanceName()));
            }
            case "SessionExpirationDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.sessionExpirationDurationInSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePresignedNotebookInstanceUrlRequest, T> g) {
        return obj -> g.apply((CreatePresignedNotebookInstanceUrlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String notebookInstanceName;
        private Integer sessionExpirationDurationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresignedNotebookInstanceUrlRequest model) {
            super(model);
            this.notebookInstanceName(model.notebookInstanceName);
            this.sessionExpirationDurationInSeconds(model.sessionExpirationDurationInSeconds);
        }

        public final String getNotebookInstanceName() {
            return this.notebookInstanceName;
        }

        @Override
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        public final Integer getSessionExpirationDurationInSeconds() {
            return this.sessionExpirationDurationInSeconds;
        }

        @Override
        public final Builder sessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
            return this;
        }

        public final void setSessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePresignedNotebookInstanceUrlRequest build() {
            return new CreatePresignedNotebookInstanceUrlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePresignedNotebookInstanceUrlRequest> {
        public Builder notebookInstanceName(String var1);

        public Builder sessionExpirationDurationInSeconds(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

