/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.EndpointSummary;
import software.amazon.awssdk.services.sagemaker.model.EndpointSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEndpointsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListEndpointsResponse> {
    private static final SdkField<List<EndpointSummary>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Endpoints").getter(ListEndpointsResponse.getter(ListEndpointsResponse::endpoints)).setter(ListEndpointsResponse.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEndpointsResponse.getter(ListEndpointsResponse::nextToken)).setter(ListEndpointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<EndpointSummary> endpoints;
    private final String nextToken;

    private ListEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.endpoints = builder.endpoints;
        this.nextToken = builder.nextToken;
    }

    public boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructList);
    }

    public List<EndpointSummary> endpoints() {
        return this.endpoints;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEndpointsResponse)) {
            return false;
        }
        ListEndpointsResponse other = (ListEndpointsResponse)((Object)obj);
        return this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListEndpointsResponse").add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEndpointsResponse, T> g) {
        return obj -> g.apply((ListEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<EndpointSummary> endpoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEndpointsResponse model) {
            super(model);
            this.endpoints(model.endpoints);
            this.nextToken(model.nextToken);
        }

        public final Collection<EndpointSummary.Builder> getEndpoints() {
            if (this.endpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endpoints != null ? (Collection)this.endpoints.stream().map(EndpointSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpoints(Collection<EndpointSummary> endpoints) {
            this.endpoints = EndpointSummaryListCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(EndpointSummary ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<EndpointSummary.Builder> ... endpoints) {
            this.endpoints(Stream.of(endpoints).map(c -> (EndpointSummary)((EndpointSummary.Builder)EndpointSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpoints(Collection<EndpointSummary.BuilderImpl> endpoints) {
            this.endpoints = EndpointSummaryListCopier.copyFromBuilder(endpoints);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEndpointsResponse build() {
            return new ListEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEndpointsResponse> {
        public Builder endpoints(Collection<EndpointSummary> var1);

        public Builder endpoints(EndpointSummary ... var1);

        public Builder endpoints(Consumer<EndpointSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

