/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.RuleEvaluationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DebugRuleEvaluationStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DebugRuleEvaluationStatus> {
    private static final SdkField<String> RULE_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleConfigurationName").getter(DebugRuleEvaluationStatus.getter(DebugRuleEvaluationStatus::ruleConfigurationName)).setter(DebugRuleEvaluationStatus.setter(Builder::ruleConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleConfigurationName").build()}).build();
    private static final SdkField<String> RULE_EVALUATION_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleEvaluationJobArn").getter(DebugRuleEvaluationStatus.getter(DebugRuleEvaluationStatus::ruleEvaluationJobArn)).setter(DebugRuleEvaluationStatus.setter(Builder::ruleEvaluationJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleEvaluationJobArn").build()}).build();
    private static final SdkField<String> RULE_EVALUATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleEvaluationStatus").getter(DebugRuleEvaluationStatus.getter(DebugRuleEvaluationStatus::ruleEvaluationStatusAsString)).setter(DebugRuleEvaluationStatus.setter(Builder::ruleEvaluationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleEvaluationStatus").build()}).build();
    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDetails").getter(DebugRuleEvaluationStatus.getter(DebugRuleEvaluationStatus::statusDetails)).setter(DebugRuleEvaluationStatus.setter(Builder::statusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DebugRuleEvaluationStatus.getter(DebugRuleEvaluationStatus::lastModifiedTime)).setter(DebugRuleEvaluationStatus.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_CONFIGURATION_NAME_FIELD, RULE_EVALUATION_JOB_ARN_FIELD, RULE_EVALUATION_STATUS_FIELD, STATUS_DETAILS_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ruleConfigurationName;
    private final String ruleEvaluationJobArn;
    private final String ruleEvaluationStatus;
    private final String statusDetails;
    private final Instant lastModifiedTime;

    private DebugRuleEvaluationStatus(BuilderImpl builder) {
        this.ruleConfigurationName = builder.ruleConfigurationName;
        this.ruleEvaluationJobArn = builder.ruleEvaluationJobArn;
        this.ruleEvaluationStatus = builder.ruleEvaluationStatus;
        this.statusDetails = builder.statusDetails;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public String ruleConfigurationName() {
        return this.ruleConfigurationName;
    }

    public String ruleEvaluationJobArn() {
        return this.ruleEvaluationJobArn;
    }

    public RuleEvaluationStatus ruleEvaluationStatus() {
        return RuleEvaluationStatus.fromValue(this.ruleEvaluationStatus);
    }

    public String ruleEvaluationStatusAsString() {
        return this.ruleEvaluationStatus;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleEvaluationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleEvaluationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DebugRuleEvaluationStatus)) {
            return false;
        }
        DebugRuleEvaluationStatus other = (DebugRuleEvaluationStatus)obj;
        return Objects.equals(this.ruleConfigurationName(), other.ruleConfigurationName()) && Objects.equals(this.ruleEvaluationJobArn(), other.ruleEvaluationJobArn()) && Objects.equals(this.ruleEvaluationStatusAsString(), other.ruleEvaluationStatusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public String toString() {
        return ToString.builder((String)"DebugRuleEvaluationStatus").add("RuleConfigurationName", (Object)this.ruleConfigurationName()).add("RuleEvaluationJobArn", (Object)this.ruleEvaluationJobArn()).add("RuleEvaluationStatus", (Object)this.ruleEvaluationStatusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.ruleConfigurationName()));
            }
            case "RuleEvaluationJobArn": {
                return Optional.ofNullable(clazz.cast(this.ruleEvaluationJobArn()));
            }
            case "RuleEvaluationStatus": {
                return Optional.ofNullable(clazz.cast(this.ruleEvaluationStatusAsString()));
            }
            case "StatusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DebugRuleEvaluationStatus, T> g) {
        return obj -> g.apply((DebugRuleEvaluationStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleConfigurationName;
        private String ruleEvaluationJobArn;
        private String ruleEvaluationStatus;
        private String statusDetails;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DebugRuleEvaluationStatus model) {
            this.ruleConfigurationName(model.ruleConfigurationName);
            this.ruleEvaluationJobArn(model.ruleEvaluationJobArn);
            this.ruleEvaluationStatus(model.ruleEvaluationStatus);
            this.statusDetails(model.statusDetails);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getRuleConfigurationName() {
            return this.ruleConfigurationName;
        }

        @Override
        public final Builder ruleConfigurationName(String ruleConfigurationName) {
            this.ruleConfigurationName = ruleConfigurationName;
            return this;
        }

        public final void setRuleConfigurationName(String ruleConfigurationName) {
            this.ruleConfigurationName = ruleConfigurationName;
        }

        public final String getRuleEvaluationJobArn() {
            return this.ruleEvaluationJobArn;
        }

        @Override
        public final Builder ruleEvaluationJobArn(String ruleEvaluationJobArn) {
            this.ruleEvaluationJobArn = ruleEvaluationJobArn;
            return this;
        }

        public final void setRuleEvaluationJobArn(String ruleEvaluationJobArn) {
            this.ruleEvaluationJobArn = ruleEvaluationJobArn;
        }

        public final String getRuleEvaluationStatus() {
            return this.ruleEvaluationStatus;
        }

        @Override
        public final Builder ruleEvaluationStatus(String ruleEvaluationStatus) {
            this.ruleEvaluationStatus = ruleEvaluationStatus;
            return this;
        }

        @Override
        public final Builder ruleEvaluationStatus(RuleEvaluationStatus ruleEvaluationStatus) {
            this.ruleEvaluationStatus(ruleEvaluationStatus == null ? null : ruleEvaluationStatus.toString());
            return this;
        }

        public final void setRuleEvaluationStatus(String ruleEvaluationStatus) {
            this.ruleEvaluationStatus = ruleEvaluationStatus;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public DebugRuleEvaluationStatus build() {
            return new DebugRuleEvaluationStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DebugRuleEvaluationStatus> {
        public Builder ruleConfigurationName(String var1);

        public Builder ruleEvaluationJobArn(String var1);

        public Builder ruleEvaluationStatus(String var1);

        public Builder ruleEvaluationStatus(RuleEvaluationStatus var1);

        public Builder statusDetails(String var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

