/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobForWorkteamSummary;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobForWorkteamSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLabelingJobsForWorkteamResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListLabelingJobsForWorkteamResponse> {
    private static final SdkField<List<LabelingJobForWorkteamSummary>> LABELING_JOB_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LabelingJobSummaryList").getter(ListLabelingJobsForWorkteamResponse.getter(ListLabelingJobsForWorkteamResponse::labelingJobSummaryList)).setter(ListLabelingJobsForWorkteamResponse.setter(Builder::labelingJobSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LabelingJobForWorkteamSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLabelingJobsForWorkteamResponse.getter(ListLabelingJobsForWorkteamResponse::nextToken)).setter(ListLabelingJobsForWorkteamResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELING_JOB_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<LabelingJobForWorkteamSummary> labelingJobSummaryList;
    private final String nextToken;

    private ListLabelingJobsForWorkteamResponse(BuilderImpl builder) {
        super(builder);
        this.labelingJobSummaryList = builder.labelingJobSummaryList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasLabelingJobSummaryList() {
        return this.labelingJobSummaryList != null && !(this.labelingJobSummaryList instanceof SdkAutoConstructList);
    }

    public List<LabelingJobForWorkteamSummary> labelingJobSummaryList() {
        return this.labelingJobSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabelingJobSummaryList() ? this.labelingJobSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLabelingJobsForWorkteamResponse)) {
            return false;
        }
        ListLabelingJobsForWorkteamResponse other = (ListLabelingJobsForWorkteamResponse)((Object)obj);
        return this.hasLabelingJobSummaryList() == other.hasLabelingJobSummaryList() && Objects.equals(this.labelingJobSummaryList(), other.labelingJobSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListLabelingJobsForWorkteamResponse").add("LabelingJobSummaryList", this.hasLabelingJobSummaryList() ? this.labelingJobSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelingJobSummaryList": {
                return Optional.ofNullable(clazz.cast(this.labelingJobSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLabelingJobsForWorkteamResponse, T> g) {
        return obj -> g.apply((ListLabelingJobsForWorkteamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<LabelingJobForWorkteamSummary> labelingJobSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLabelingJobsForWorkteamResponse model) {
            super(model);
            this.labelingJobSummaryList(model.labelingJobSummaryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<LabelingJobForWorkteamSummary.Builder> getLabelingJobSummaryList() {
            if (this.labelingJobSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labelingJobSummaryList != null ? (Collection)this.labelingJobSummaryList.stream().map(LabelingJobForWorkteamSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder labelingJobSummaryList(Collection<LabelingJobForWorkteamSummary> labelingJobSummaryList) {
            this.labelingJobSummaryList = LabelingJobForWorkteamSummaryListCopier.copy(labelingJobSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelingJobSummaryList(LabelingJobForWorkteamSummary ... labelingJobSummaryList) {
            this.labelingJobSummaryList(Arrays.asList(labelingJobSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelingJobSummaryList(Consumer<LabelingJobForWorkteamSummary.Builder> ... labelingJobSummaryList) {
            this.labelingJobSummaryList(Stream.of(labelingJobSummaryList).map(c -> (LabelingJobForWorkteamSummary)((LabelingJobForWorkteamSummary.Builder)LabelingJobForWorkteamSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLabelingJobSummaryList(Collection<LabelingJobForWorkteamSummary.BuilderImpl> labelingJobSummaryList) {
            this.labelingJobSummaryList = LabelingJobForWorkteamSummaryListCopier.copyFromBuilder(labelingJobSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListLabelingJobsForWorkteamResponse build() {
            return new ListLabelingJobsForWorkteamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLabelingJobsForWorkteamResponse> {
        public Builder labelingJobSummaryList(Collection<LabelingJobForWorkteamSummary> var1);

        public Builder labelingJobSummaryList(LabelingJobForWorkteamSummary ... var1);

        public Builder labelingJobSummaryList(Consumer<LabelingJobForWorkteamSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

