/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CustomImage;
import software.amazon.awssdk.services.sagemaker.model.CustomImagesCopier;
import software.amazon.awssdk.services.sagemaker.model.ResourceSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KernelGatewayAppSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KernelGatewayAppSettings> {
    private static final SdkField<ResourceSpec> DEFAULT_RESOURCE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultResourceSpec").getter(KernelGatewayAppSettings.getter(KernelGatewayAppSettings::defaultResourceSpec)).setter(KernelGatewayAppSettings.setter(Builder::defaultResourceSpec)).constructor(ResourceSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultResourceSpec").build()}).build();
    private static final SdkField<List<CustomImage>> CUSTOM_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomImages").getter(KernelGatewayAppSettings.getter(KernelGatewayAppSettings::customImages)).setter(KernelGatewayAppSettings.setter(Builder::customImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomImages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_RESOURCE_SPEC_FIELD, CUSTOM_IMAGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final ResourceSpec defaultResourceSpec;
    private final List<CustomImage> customImages;

    private KernelGatewayAppSettings(BuilderImpl builder) {
        this.defaultResourceSpec = builder.defaultResourceSpec;
        this.customImages = builder.customImages;
    }

    public ResourceSpec defaultResourceSpec() {
        return this.defaultResourceSpec;
    }

    public boolean hasCustomImages() {
        return this.customImages != null && !(this.customImages instanceof SdkAutoConstructList);
    }

    public List<CustomImage> customImages() {
        return this.customImages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResourceSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.customImages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KernelGatewayAppSettings)) {
            return false;
        }
        KernelGatewayAppSettings other = (KernelGatewayAppSettings)obj;
        return Objects.equals(this.defaultResourceSpec(), other.defaultResourceSpec()) && Objects.equals(this.customImages(), other.customImages());
    }

    public String toString() {
        return ToString.builder((String)"KernelGatewayAppSettings").add("DefaultResourceSpec", (Object)this.defaultResourceSpec()).add("CustomImages", this.customImages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultResourceSpec": {
                return Optional.ofNullable(clazz.cast(this.defaultResourceSpec()));
            }
            case "CustomImages": {
                return Optional.ofNullable(clazz.cast(this.customImages()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KernelGatewayAppSettings, T> g) {
        return obj -> g.apply((KernelGatewayAppSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ResourceSpec defaultResourceSpec;
        private List<CustomImage> customImages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KernelGatewayAppSettings model) {
            this.defaultResourceSpec(model.defaultResourceSpec);
            this.customImages(model.customImages);
        }

        public final ResourceSpec.Builder getDefaultResourceSpec() {
            return this.defaultResourceSpec != null ? this.defaultResourceSpec.toBuilder() : null;
        }

        @Override
        public final Builder defaultResourceSpec(ResourceSpec defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec;
            return this;
        }

        public final void setDefaultResourceSpec(ResourceSpec.BuilderImpl defaultResourceSpec) {
            this.defaultResourceSpec = defaultResourceSpec != null ? defaultResourceSpec.build() : null;
        }

        public final Collection<CustomImage.Builder> getCustomImages() {
            return this.customImages != null ? (Collection)this.customImages.stream().map(CustomImage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customImages(Collection<CustomImage> customImages) {
            this.customImages = CustomImagesCopier.copy(customImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customImages(CustomImage ... customImages) {
            this.customImages(Arrays.asList(customImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customImages(Consumer<CustomImage.Builder> ... customImages) {
            this.customImages(Stream.of(customImages).map(c -> (CustomImage)((CustomImage.Builder)CustomImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomImages(Collection<CustomImage.BuilderImpl> customImages) {
            this.customImages = CustomImagesCopier.copyFromBuilder(customImages);
        }

        public KernelGatewayAppSettings build() {
            return new KernelGatewayAppSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KernelGatewayAppSettings> {
        public Builder defaultResourceSpec(ResourceSpec var1);

        default public Builder defaultResourceSpec(Consumer<ResourceSpec.Builder> defaultResourceSpec) {
            return this.defaultResourceSpec((ResourceSpec)((ResourceSpec.Builder)ResourceSpec.builder().applyMutation(defaultResourceSpec)).build());
        }

        public Builder customImages(Collection<CustomImage> var1);

        public Builder customImages(CustomImage ... var1);

        public Builder customImages(Consumer<CustomImage.Builder> ... var1);
    }
}

